/*
 * Decompiled with CFR 0.152.
 */
package com.byh.module.onlineoutser.view;

import android.content.Context;
import android.database.DataSetObserver;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.widget.Adapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.SectionIndexer;
import androidx.core.content.ContextCompat;
import com.kangxin.common.R;

public class IndexableListView
extends ListView {
    private boolean mIsFastScrollEnabled = false;
    private IndexScroller mScroller = null;

    public IndexableListView(Context context) {
        super(context);
    }

    public IndexableListView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public IndexableListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public boolean isFastScrollEnabled() {
        return this.mIsFastScrollEnabled;
    }

    public void setFastScrollEnabled(boolean enabled) {
        this.mIsFastScrollEnabled = enabled;
        if (this.mIsFastScrollEnabled && this.mScroller == null) {
            this.mScroller = new IndexScroller(this.getContext(), this);
        }
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        if (this.mScroller != null) {
            this.mScroller.draw(canvas);
        }
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (this.mScroller != null && this.mScroller.onTouchEvent(ev)) {
            return true;
        }
        return super.onTouchEvent(ev);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (this.mScroller != null && this.mScroller.contains(ev.getX(), ev.getY())) {
            return true;
        }
        return super.onInterceptTouchEvent(ev);
    }

    public void setAdapter(ListAdapter adapter) {
        super.setAdapter(adapter);
        if (this.mScroller != null) {
            this.mScroller.setAdapter((Adapter)adapter);
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (this.mScroller != null) {
            this.mScroller.onSizeChanged(w, h, oldw, oldh);
        }
    }

    public class IndexScroller
    extends DataSetObserver {
        private float mPreviewPadding;
        private float mDensity;
        private float mScaledDensity;
        private int mListViewWidth;
        private int mListViewHeight;
        private int mCurrentSection = -1;
        private int mMin = 26;
        private boolean mIsIndexing = false;
        private ListView mListView = null;
        private SectionIndexer mIndexer = null;
        private String[] mSections = null;
        private RectF mIndexbarRect;
        private float mSingle;
        private Context mContext;
        private Paint mIndexPaint;
        private float mHeight;
        private float mWidth;
        private float mGap;
        private float mBaseLineToTop;
        private float mMaxSingleWidth;
        private float mPadding;

        IndexScroller(Context context, ListView lv) {
            this.mContext = context;
            this.mDensity = context.getResources().getDisplayMetrics().density;
            this.mScaledDensity = context.getResources().getDisplayMetrics().scaledDensity;
            this.mListView = lv;
            this.setAdapter((Adapter)this.mListView.getAdapter());
            this.mPreviewPadding = 1.0f * this.mDensity;
            this.mGap = 6.0f * this.mDensity;
            this.mPadding = 8.0f * this.mDensity;
            this.mIndexPaint = new Paint();
            this.mIndexPaint.setColor(ContextCompat.getColor((Context)this.mContext, (int)R.color.online_c66));
            this.mIndexPaint.setAntiAlias(true);
            this.mIndexPaint.setTextSize(TypedValue.applyDimension((int)2, (float)12.0f, (DisplayMetrics)this.mContext.getResources().getDisplayMetrics()));
            this.mIndexPaint.setTextAlign(Paint.Align.CENTER);
        }

        void draw(Canvas canvas) {
            if (this.mSections != null && this.mSections.length > 0) {
                if (this.mCurrentSection >= 0) {
                    Paint previewPaint = new Paint();
                    previewPaint.setColor(-16777216);
                    previewPaint.setAlpha(96);
                    previewPaint.setAntiAlias(true);
                    previewPaint.setShadowLayer(3.0f, 0.0f, 0.0f, Color.argb((int)64, (int)0, (int)0, (int)0));
                    Paint previewTextPaint = new Paint();
                    previewTextPaint.setColor(-1);
                    previewTextPaint.setAntiAlias(true);
                    previewTextPaint.setTextSize(50.0f * this.mScaledDensity);
                    float previewTextWidth = previewTextPaint.measureText(this.mSections[this.mCurrentSection]);
                    float previewSize = 2.0f * this.mPreviewPadding + previewTextPaint.descent() - previewTextPaint.ascent();
                    RectF previewRect = new RectF(((float)this.mListViewWidth - previewSize) / 2.0f, ((float)this.mListViewHeight - previewSize) / 2.0f, ((float)this.mListViewWidth - previewSize) / 2.0f + previewSize, ((float)this.mListViewHeight - previewSize) / 2.0f + previewSize);
                    canvas.drawRoundRect(previewRect, 5.0f * this.mDensity, 5.0f * this.mDensity, previewPaint);
                    canvas.drawText(this.mSections[this.mCurrentSection], previewRect.left + (previewSize - previewTextWidth) / 2.0f - 1.0f, previewRect.top + this.mPreviewPadding - previewTextPaint.ascent() + 1.0f, previewTextPaint);
                }
                for (int i = 0; i < this.mSections.length; ++i) {
                    canvas.drawText(this.mSections[i], this.mIndexbarRect.left + this.mMaxSingleWidth / 2.0f + this.mPadding, this.mIndexbarRect.top + (float)i * (this.mSingle + this.mGap) + this.mBaseLineToTop, this.mIndexPaint);
                }
            }
        }

        boolean onTouchEvent(MotionEvent ev) {
            switch (ev.getAction()) {
                case 0: {
                    if (!this.contains(ev.getX(), ev.getY())) break;
                    this.mIsIndexing = true;
                    this.mCurrentSection = this.getSectionByPoint(ev.getY());
                    this.mListView.setSelection(this.mIndexer.getPositionForSection(this.mCurrentSection));
                    return true;
                }
                case 2: {
                    if (!this.mIsIndexing) break;
                    if (this.contains(ev.getX(), ev.getY())) {
                        this.mCurrentSection = this.getSectionByPoint(ev.getY());
                        this.mListView.setSelection(this.mIndexer.getPositionForSection(this.mCurrentSection));
                    }
                    return true;
                }
                case 1: {
                    if (!this.mIsIndexing) break;
                    this.mIsIndexing = false;
                    this.mCurrentSection = -1;
                }
            }
            return false;
        }

        boolean contains(float x, float y) {
            return x >= this.mIndexbarRect.left && y >= this.mIndexbarRect.top && y <= this.mIndexbarRect.bottom;
        }

        void onSizeChanged(int w, int h, int oldw, int oldh) {
            this.mListViewWidth = w;
            this.mListViewHeight = h;
            float margin = ((float)this.mListViewHeight - this.mHeight) / 2.0f;
            this.mIndexbarRect = new RectF((float)w - this.mWidth, margin, (float)w, (float)h - margin);
        }

        private int getSectionByPoint(float y) {
            if (this.mSections == null || this.mSections.length == 0) {
                return 0;
            }
            return (int)Math.floor((y - this.mIndexbarRect.top) / (this.mSingle + this.mGap));
        }

        void setAdapter(Adapter adapter) {
            if (adapter instanceof SectionIndexer) {
                this.mIndexer = (SectionIndexer)adapter;
                this.mSections = (String[])this.mIndexer.getSections();
                adapter.registerDataSetObserver((DataSetObserver)this);
                Paint.FontMetrics fm = this.mIndexPaint.getFontMetrics();
                this.mSingle = fm.bottom - fm.top + fm.leading;
                this.mBaseLineToTop = this.mSingle - fm.bottom;
                this.mHeight = this.mSingle * (float)this.mSections.length + this.mGap * (float)(this.mSections.length - 1);
                for (String s : this.mSections) {
                    float w = this.mIndexPaint.measureText(s);
                    if (!(this.mMaxSingleWidth < w)) continue;
                    this.mMaxSingleWidth = w;
                }
                this.mWidth = this.mMaxSingleWidth + this.mPadding * 2.0f;
            }
        }

        public void onChanged() {
            this.mSections = (String[])this.mIndexer.getSections();
            this.mListView.invalidate();
        }
    }
}

