/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.byh.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.kangxin.common.R;
import com.kangxin.common.byh.widget.DefaultEmptyPage;
import com.scwang.smartrefresh.layout.SmartRefreshLayout;
import com.scwang.smartrefresh.layout.api.RefreshFooter;
import com.scwang.smartrefresh.layout.api.RefreshHeader;
import com.scwang.smartrefresh.layout.api.RefreshLayout;
import com.scwang.smartrefresh.layout.footer.ClassicsFooter;
import com.scwang.smartrefresh.layout.header.ClassicsHeader;
import com.scwang.smartrefresh.layout.listener.OnLoadmoreListener;
import com.scwang.smartrefresh.layout.listener.OnRefreshListener;
import java.util.Collection;
import java.util.List;

public class SmartRecyclerView
extends RelativeLayout {
    private SmartRefreshLayout mSmartRefreshLayoutView;
    private RecyclerView mRecyclerView;
    private BaseQuickAdapter mAdapter;
    private int mIndex = 1;
    private int mImgId;
    private String mBtnText;
    private String mDefDescText;
    private String mDefDescEnglishText;
    private OnClickDefEmptyBtnListener onClickDefEmptyBtnListener;
    private DefaultEmptyPage mDefEmptyPage;

    public void setOnClickDefEmptyBtnListener(OnClickDefEmptyBtnListener onClickDefEmptyBtnListener) {
        this.onClickDefEmptyBtnListener = onClickDefEmptyBtnListener;
    }

    public SmartRecyclerView(Context context) {
        this(context, null);
    }

    public SmartRecyclerView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SmartRecyclerView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        View smartRootView = LayoutInflater.from((Context)context).inflate(R.layout.commbyh_smart_recyclerview_list_layout, (ViewGroup)this, false);
        this.addView(smartRootView);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.SmartRecyclerView);
        if (typedArray != null) {
            this.mImgId = typedArray.getResourceId(R.styleable.SmartRecyclerView_seat_img, 0);
            this.mDefDescText = typedArray.getString(R.styleable.SmartRecyclerView_seat_desc);
            this.mBtnText = typedArray.getString(R.styleable.SmartRecyclerView_seat_btn_text);
            this.mDefDescEnglishText = typedArray.getString(R.styleable.SmartRecyclerView_seat_desc_eng);
            typedArray.recycle();
        }
        this.mSmartRefreshLayoutView = (SmartRefreshLayout)this.findViewById(R.id.smart_refresh_layout);
        this.mSmartRefreshLayoutView.setRefreshHeader((RefreshHeader)new ClassicsHeader(context));
        this.mSmartRefreshLayoutView.setRefreshFooter((RefreshFooter)new ClassicsFooter(context));
        this.mRecyclerView = (RecyclerView)this.findViewById(R.id.recycler_list);
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(context));
    }

    public SmartRecyclerView setAdapter(BaseQuickAdapter baseQuickAdapter) {
        this.mAdapter = baseQuickAdapter;
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)baseQuickAdapter);
        return this;
    }

    public boolean isRefresh() {
        return this.mSmartRefreshLayoutView.isRefreshing() || this.mSmartRefreshLayoutView.isLoading();
    }

    public SmartRecyclerView autoRefresh() {
        this.mSmartRefreshLayoutView.autoRefresh();
        return this;
    }

    public SmartRecyclerView addItemDecoration(@NonNull RecyclerView.ItemDecoration decor) {
        this.mRecyclerView.addItemDecoration(decor);
        return this;
    }

    public SmartRecyclerView setRecyclerViewColor(@ColorInt int color2) {
        this.mRecyclerView.setBackgroundColor(color2);
        return this;
    }

    public int getIndex() {
        return this.mIndex;
    }

    public void setIndex(int index) {
        this.mIndex = index;
    }

    public void showNoData() {
        if (this.mIndex == 1) {
            if (this.mDefEmptyPage != null) {
                this.mDefEmptyPage.showDef(true);
            } else {
                this.initDefEmptyPage(null);
            }
        }
    }

    private <T> void initDefEmptyPage(Collection<? extends T> newData) {
        this.mDefEmptyPage = new DefaultEmptyPage.Builder(this.getContext()).setDefImgid(this.mImgId).setDefDescText(this.mDefDescText).setDefEngText(this.mDefDescEnglishText).setDefBtnText(this.mBtnText).setDataList((List)newData).setBusViewGroup((ViewGroup)this.mRecyclerView).setOnDefpageClickListener(new DefaultEmptyPage.OnDefpageClickListener(){

            @Override
            public void onClickDefbtn(View view) {
                if (SmartRecyclerView.this.onClickDefEmptyBtnListener != null) {
                    SmartRecyclerView.this.onClickDefEmptyBtnListener.onClickDefBtnView(view);
                }
            }
        }).create();
    }

    public <T> void loadDatas(Collection<? extends T> newData) {
        this.mSmartRefreshLayoutView.finishRefresh();
        this.mSmartRefreshLayoutView.finishLoadmore();
        this.initDefEmptyPage(newData);
        if (newData == null || newData.isEmpty() || this.mAdapter == null) {
            if (this.mIndex == 1) {
                this.mDefEmptyPage.showDef(true);
            }
            return;
        }
        this.mDefEmptyPage.showDef(false);
        if (this.mIndex == 1) {
            this.mAdapter.getData().clear();
            this.mAdapter.addData(newData);
        } else {
            this.mAdapter.addData(this.mAdapter.getItemCount(), newData);
        }
    }

    public void setEnablePullAndLoadMore(boolean isRefresh, boolean isLoadMore) {
        this.mSmartRefreshLayoutView.setEnableRefresh(isRefresh);
        this.mSmartRefreshLayoutView.setEnableLoadmore(isLoadMore);
    }

    public void finishRefAndLoadMore() {
        this.mSmartRefreshLayoutView.finishLoadmore();
        this.mSmartRefreshLayoutView.finishRefresh();
    }

    public void setOnPullRefreshListener(final OnPullRefreshListener onPullRefreshListener) {
        this.mSmartRefreshLayoutView.setOnRefreshListener(new OnRefreshListener(){

            public void onRefresh(RefreshLayout refreshlayout) {
                SmartRecyclerView.this.mIndex = 1;
                onPullRefreshListener.onRefresh(SmartRecyclerView.this.mIndex);
            }
        });
        this.mSmartRefreshLayoutView.setOnLoadmoreListener(new OnLoadmoreListener(){

            public void onLoadmore(RefreshLayout refreshlayout) {
                SmartRecyclerView.this.mIndex++;
                onPullRefreshListener.onLoadMore(SmartRecyclerView.this.mIndex);
            }
        });
    }

    public static interface OnPullRefreshListener {
        public void onRefresh(int var1);

        public void onLoadMore(int var1);
    }

    public static interface OnClickDefEmptyBtnListener {
        public void onClickDefBtnView(View var1);
    }
}

