/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.http.entity;

import android.util.Log;
import androidx.annotation.Nullable;
import com.kangxin.common.http.listener.DownListener;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;
import okio.ForwardingSource;
import okio.Okio;
import okio.Source;

public class DownResponseBody
extends ResponseBody {
    private ResponseBody responseBody;
    private DownListener downListener;
    private BufferedSource bufferedSource;

    public DownResponseBody(ResponseBody responseBody, DownListener downListener) {
        this.responseBody = responseBody;
        this.downListener = downListener;
    }

    @Nullable
    public MediaType contentType() {
        return this.responseBody.contentType();
    }

    public long contentLength() {
        return this.responseBody.contentLength();
    }

    public BufferedSource source() {
        if (this.bufferedSource == null) {
            this.bufferedSource = Okio.buffer((Source)this.source((Source)this.responseBody.source()));
        }
        return this.bufferedSource;
    }

    private Source source(Source source) {
        return new ForwardingSource(source){
            long totalBytesRead;
            {
                this.totalBytesRead = 0L;
            }

            public long read(Buffer sink, long byteCount) throws IOException {
                long bytesRead = super.read(sink, byteCount);
                this.totalBytesRead += bytesRead != -1L ? bytesRead : 0L;
                Log.e((String)"download", (String)("read: " + (int)(this.totalBytesRead * 100L / DownResponseBody.this.responseBody.contentLength())));
                if (null != DownResponseBody.this.downListener && bytesRead != -1L) {
                    DownResponseBody.this.downListener.downProgress((int)(this.totalBytesRead * 100L / DownResponseBody.this.responseBody.contentLength()));
                }
                return bytesRead;
            }
        };
    }
}

