/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.base;

import androidx.recyclerview.widget.RecyclerView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public abstract class BaseAdapter<T, VH extends RecyclerView.ViewHolder>
extends RecyclerView.Adapter<VH> {
    private ArrayList<T> items = new ArrayList();

    public BaseAdapter() {
        this.setHasStableIds(true);
    }

    public void add(T object) {
        this.items.add(object);
        this.notifyDataSetChanged();
    }

    public void add(int index, T object) {
        this.items.add(index, object);
        this.notifyDataSetChanged();
    }

    public void addAll(Collection<T> collection) {
        if (collection != null) {
            this.items.clear();
            this.items.addAll(collection);
            this.notifyDataSetChanged();
        }
    }

    public void addAll(T ... items) {
        this.addAll((Collection<T>)Arrays.asList(items));
    }

    public void clear() {
        this.items.clear();
        this.notifyDataSetChanged();
    }

    public void remove(T object) {
        this.items.remove(object);
        this.notifyDataSetChanged();
    }

    public T getItem(int position) {
        return this.items.get(position);
    }

    public long getItemId(int position) {
        return this.getItem(position).hashCode();
    }

    public int getItemCount() {
        return this.items.size();
    }
}

