/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.util;

import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.LayoutRes;
import androidx.recyclerview.widget.RecyclerView;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.kangxin.common.util.GlobeLoadingHelper;
import com.scwang.smartrefresh.layout.SmartRefreshLayout;
import com.scwang.smartrefresh.layout.api.RefreshLayout;
import com.scwang.smartrefresh.layout.listener.OnRefreshListener;
import java.util.ArrayList;
import java.util.List;

public class SmartRefreshHelper<E> {
    private static final int FIRST_PAGE = 0;
    private final RefreshLayout refreshLayout;
    private final BaseQuickAdapter<E, BaseViewHolder> adapter;
    private int perPageCount = 0;
    private int duration = 300;
    private RefreshCallback callback = null;
    private int currentPage = 0;
    private boolean refreshEnable = true;
    private boolean loadMoreEnable = true;
    private int emptyId = 0;

    private SmartRefreshHelper(RefreshLayout layout2, BaseQuickAdapter<E, BaseViewHolder> adapter) {
        this.refreshLayout = layout2;
        this.adapter = adapter;
        this.refreshLayout.setEnableOverScrollBounce(true);
        this.refreshLayout.setEnableAutoLoadmore(false);
    }

    public static void pureScrollMode(RefreshLayout layout2) {
        layout2.setEnablePureScrollMode(true);
        layout2.setEnableOverScrollBounce(true);
        layout2.setEnableNestedScroll(true);
        layout2.setEnablePureScrollMode(true);
    }

    public static <E> SmartRefreshHelper<E> with(SmartRefreshLayout layout2, BaseQuickAdapter<E, BaseViewHolder> adapter) {
        return new SmartRefreshHelper<E>((RefreshLayout)layout2, adapter);
    }

    public SmartRefreshHelper<E> setPerPageCount(int perPageCount) {
        this.perPageCount = perPageCount;
        return this;
    }

    public SmartRefreshHelper<E> setRefreshEnable(boolean refreshEnable) {
        this.refreshEnable = refreshEnable;
        return this;
    }

    public SmartRefreshHelper<E> setLoadMoreEnable(boolean loadMoreEnable) {
        this.loadMoreEnable = loadMoreEnable;
        return this;
    }

    public SmartRefreshHelper<E> setEmptyId(@LayoutRes int emptyId) {
        this.emptyId = emptyId;
        return this;
    }

    public SmartRefreshHelper<E> init(RefreshCallback refreshCallback) {
        this.callback = refreshCallback;
        this.refreshLayout.setEnableRefresh(this.refreshEnable);
        if (this.refreshEnable) {
            this.refreshLayout.setOnRefreshListener(new OnRefreshListener(){

                public void onRefresh(RefreshLayout refreshLayout) {
                    SmartRefreshHelper.this.requestFirstPage(false);
                }
            });
        }
        this.refreshLayout.setEnableLoadmore(false);
        RecyclerView v = null;
        for (int i = 0; i < this.refreshLayout.getLayout().getChildCount(); ++i) {
            if (!(this.refreshLayout.getLayout().getChildAt(i) instanceof RecyclerView)) continue;
            v = (RecyclerView)this.refreshLayout.getLayout().getChildAt(i);
        }
        this.adapter.setEnableLoadMore(this.loadMoreEnable);
        if (this.loadMoreEnable) {
            this.adapter.setOnLoadMoreListener(new BaseQuickAdapter.RequestLoadMoreListener(){

                public void onLoadMoreRequested() {
                    SmartRefreshHelper.this.currentPage++;
                    if (SmartRefreshHelper.this.callback != null) {
                        SmartRefreshHelper.this.callback.doRequestData(SmartRefreshHelper.this.currentPage);
                    }
                }
            }, v);
        }
        return this;
    }

    public SmartRefreshHelper<E> requestFirstPage(boolean loading) {
        if (loading) {
            this.showCenterLoading();
        }
        this.currentPage = 0;
        if (this.callback != null) {
            this.callback.doRequestData(this.currentPage);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSuccess(List<E> data) {
        BaseQuickAdapter<E, BaseViewHolder> baseQuickAdapter = this.adapter;
        synchronized (baseQuickAdapter) {
            this.hideCenterLoading();
            if (this.currentPage <= 0) {
                this.adapter.setNewData(data);
                if (this.perPageCount > 0) {
                    if (data != null && data.size() == this.perPageCount) {
                        this.adapter.loadMoreComplete();
                    } else if (data != null && data.size() > 0) {
                        this.adapter.loadMoreEnd();
                    } else if (this.emptyId != 0) {
                        this.adapter.setEmptyView(this.emptyId, (ViewGroup)this.refreshLayout);
                    }
                }
            } else if (data == null || data.size() == 0) {
                --this.currentPage;
                if (this.perPageCount > 0) {
                    this.adapter.loadMoreEnd();
                }
            } else if (data.size() == this.perPageCount) {
                this.adapter.addData(data);
                this.adapter.loadMoreComplete();
            } else {
                this.adapter.addData(data);
                this.adapter.loadMoreEnd();
            }
            this.refreshLayout.finishRefresh(this.duration, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFailed() {
        BaseQuickAdapter<E, BaseViewHolder> baseQuickAdapter = this.adapter;
        synchronized (baseQuickAdapter) {
            this.hideCenterLoading();
            if (this.currentPage <= 0) {
                this.adapter.setNewData(new ArrayList());
                if (this.perPageCount > 0) {
                    this.adapter.loadMoreComplete();
                }
            } else {
                --this.currentPage;
                if (this.perPageCount > 0) {
                    this.adapter.loadMoreFail();
                }
            }
            this.refreshLayout.finishRefresh(this.duration, false);
        }
    }

    private void showCenterLoading() {
        GlobeLoadingHelper.show(((View)this.refreshLayout).getContext());
    }

    private void hideCenterLoading() {
        GlobeLoadingHelper.dissmiss();
    }

    public static interface RefreshCallback {
        public void doRequestData(int var1);
    }
}

