/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.AbsListView;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.kangxin.common.R;
import com.kangxin.doctor.worktable.widget.WheelAdapter;
import java.util.List;

public class WheelListView
extends ListView
implements AbsListView.OnScrollListener {
    public static final int WHEEL_SIZE = 5;
    private int mItemHeight;
    private int mCurrentPosition;
    private List<String> mLabels;
    private WheelAdapter mWheelAdapter;

    public WheelListView(Context context) {
        this(context, null);
    }

    public WheelListView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public WheelListView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    public void onScrollStateChanged(AbsListView view, int scrollState) {
        this.refreshState(scrollState);
    }

    public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        this.refreshItems();
    }

    private void init() {
        this.mWheelAdapter = new WheelAdapter();
        this.setAdapter((ListAdapter)this.mWheelAdapter);
        this.setVerticalScrollBarEnabled(false);
        this.setScrollingCacheEnabled(false);
        this.setCacheColorHint(0);
        this.setFadingEdgeLength(0);
        this.setOverScrollMode(2);
        this.setDividerHeight(0);
        this.setOnScrollListener(this);
    }

    protected void dispatchDraw(Canvas canvas) {
        canvas.drawColor(-1);
        Paint dividerPaint = new Paint();
        dividerPaint.setColor(Color.parseColor((String)"#00000000"));
        dividerPaint.setStrokeWidth(2.0f);
        int viewWidth = this.getWidth();
        int startY = this.mItemHeight * 2;
        int endY = this.mItemHeight * 3;
        canvas.drawLine(0.0f, (float)startY, (float)viewWidth, (float)startY, dividerPaint);
        canvas.drawLine(0.0f, (float)endY, (float)viewWidth, (float)endY, dividerPaint);
        super.dispatchDraw(canvas);
    }

    public void setLabels(List<String> labels) {
        this.mLabels = labels;
        this.mWheelAdapter.update(this.mLabels);
        this.initView();
    }

    public String getSelectLabel() {
        return this.mLabels.get(this.mCurrentPosition);
    }

    public int getSelectIndex() {
        return this.mCurrentPosition;
    }

    private void initView() {
        View itemView = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.worktab_by_item_widget_wheel, null);
        itemView.measure(0, 0);
        this.mItemHeight = itemView.getMeasuredHeight();
        this.getLayoutParams().height = this.mItemHeight * 5;
        this.mWheelAdapter.update(this.mLabels);
    }

    private void refreshItems() {
        int temp;
        if (this.getChildAt(0) == null) {
            return;
        }
        int offset = 2;
        int firstPosition = this.getFirstVisiblePosition();
        int position = firstPosition + offset;
        if (Math.abs(this.getChildAt(0).getY()) > (float)(this.mItemHeight / 2)) {
            position = firstPosition + offset + 1;
        }
        this.mCurrentPosition = (temp = position - 2) < 0 ? 0 : temp;
        for (int i = position - offset; i <= position + offset; ++i) {
            View itemView = this.getChildAt(i - firstPosition);
            if (itemView == null) continue;
            if (position == i) {
                itemView.setAlpha(1.0f);
                continue;
            }
            int delta = Math.abs(i - position);
            itemView.setAlpha((float)Math.pow(0.4f, delta));
        }
    }

    private void refreshState(int scrollState) {
        if (scrollState == 0) {
            View itemView = this.getChildAt(0);
            if (itemView == null) {
                return;
            }
            float deltaY = itemView.getY();
            if (deltaY == 0.0f) {
                return;
            }
            if (Math.abs(deltaY) < (float)(this.mItemHeight / 2)) {
                this.smoothScrollBy(this.getDistance(deltaY), 50);
            } else {
                this.smoothScrollBy(this.getDistance((float)this.mItemHeight + deltaY), 50);
            }
        }
    }

    private int getDistance(float scrollDistance) {
        if (Math.abs(scrollDistance) <= 2.0f) {
            return (int)scrollDistance;
        }
        if (Math.abs(scrollDistance) < 12.0f) {
            return scrollDistance > 0.0f ? 2 : -2;
        }
        return (int)(scrollDistance / 6.0f);
    }
}

