/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.widget;

import android.app.Dialog;
import android.content.Context;
import android.view.View;
import android.view.WindowManager;
import android.widget.Toast;
import androidx.annotation.NonNull;
import com.kangxin.common.R;

public abstract class BottomDialog
extends Dialog {
    protected View mRootView = this.getLayoutInflater().inflate(this.getLayoutId(), null);
    protected Context mContext;

    public BottomDialog(@NonNull Context context) {
        this(context, R.style.dialog_reminder);
        this.getWindow().setGravity(80);
        this.mContext = context.getApplicationContext();
    }

    public BottomDialog(@NonNull Context context, int themeResId) {
        super(context, themeResId);
        this.initView();
        this.initStyle();
    }

    private void initStyle() {
        this.requestWindowFeature(1);
        this.mRootView.setMinimumWidth(10000);
        this.setContentView(this.mRootView);
        WindowManager.LayoutParams p = this.getWindow().getAttributes();
        p.width = -1;
        p.height = -1;
        p.alpha = 0.95f;
        this.getWindow().setAttributes(p);
        this.getWindow().setWindowAnimations(R.style.AnimBottom);
        View decorView = this.getWindow().getDecorView();
        decorView.setSystemUiVisibility(4610);
        this.getWindow().setLayout(-1, -2);
    }

    protected void showShortToast(String msg) {
        Toast.makeText((Context)this.mContext, (CharSequence)msg, (int)0).show();
    }

    protected abstract int getLayoutId();

    protected abstract void initView();

    protected <T extends View> T findViewById(View view, int id2) {
        return (T)view.findViewById(id2);
    }

    public <T extends View> T findViewById(int id2) {
        return (T)this.mRootView.findViewById(id2);
    }
}

