/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.widget;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.ColorInt;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class LinePathView
extends View {
    private static final String TAG = "LinePathView";
    private final Paint mGesturePaint = new Paint();
    private final Path mPath = new Path();
    private Context mContext;
    private float mX;
    private float mY;
    private Canvas cacheCanvas;
    private Bitmap cachebBitmap;
    private boolean isTouched = false;
    private int mPaintWidth = 10;
    private int mPenColor = -16777216;
    private int mBackColor = 0;

    public LinePathView(Context context) {
        super(context);
        this.init(context);
    }

    public LinePathView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public LinePathView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    public void init(Context context) {
        this.mContext = context;
        this.mGesturePaint.setAntiAlias(true);
        this.mGesturePaint.setStyle(Paint.Style.STROKE);
        this.mGesturePaint.setStrokeWidth((float)this.mPaintWidth);
        this.mGesturePaint.setColor(this.mPenColor);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.cachebBitmap = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.cacheCanvas = new Canvas(this.cachebBitmap);
        this.cacheCanvas.drawColor(this.mBackColor, PorterDuff.Mode.CLEAR);
        this.isTouched = false;
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.touchDown(event);
                break;
            }
            case 2: {
                this.isTouched = true;
                this.touchMove(event);
                break;
            }
            case 1: {
                this.cacheCanvas.drawPath(this.mPath, this.mGesturePaint);
                this.mPath.reset();
            }
        }
        this.invalidate();
        return true;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.drawBitmap(this.cachebBitmap, 0.0f, 0.0f, this.mGesturePaint);
        canvas.drawPath(this.mPath, this.mGesturePaint);
    }

    private void touchDown(MotionEvent event) {
        this.mPath.reset();
        float x = event.getX();
        float y = event.getY();
        this.mX = x;
        this.mY = y;
        this.mPath.moveTo(x, y);
    }

    private void touchMove(MotionEvent event) {
        float x = event.getX();
        float y = event.getY();
        float previousX = this.mX;
        float previousY = this.mY;
        float dx = Math.abs(x - previousX);
        float dy = Math.abs(y - previousY);
        if (dx >= 3.0f || dy >= 3.0f) {
            float cX = (x + previousX) / 2.0f;
            float cY = (y + previousY) / 2.0f;
            this.mPath.quadTo(previousX, previousY, cX, cY);
            this.mX = x;
            this.mY = y;
        }
    }

    public void clear() {
        if (this.cacheCanvas != null) {
            this.isTouched = false;
            this.mGesturePaint.setColor(this.mPenColor);
            this.cacheCanvas.drawColor(this.mBackColor, PorterDuff.Mode.CLEAR);
            this.mGesturePaint.setColor(this.mPenColor);
            this.invalidate();
        }
    }

    public void save(String path) {
        try {
            String realPath = this.mContext.getExternalCacheDir() + path;
            this.save(realPath, false, 0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String saveBitmap(String path) {
        String realPath = null;
        try {
            realPath = this.mContext.getExternalCacheDir() + path;
            this.save(realPath, false, 0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Log.i((String)TAG, (String)("saveBitmap: realPath:" + realPath));
        return realPath;
    }

    public void save(String path, boolean clearBlank, int blank) throws IOException {
        Bitmap bitmap = this.cachebBitmap;
        if (clearBlank) {
            bitmap = this.clearBlank(bitmap, blank);
        }
        File file = new File(path);
        FileOutputStream outputStream = new FileOutputStream(file);
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)outputStream);
        outputStream.flush();
        ((OutputStream)outputStream).close();
    }

    public Bitmap getBitMap() {
        this.setDrawingCacheEnabled(false);
        this.buildDrawingCache();
        Bitmap bitmap = this.getDrawingCache();
        this.setDrawingCacheEnabled(false);
        return bitmap;
    }

    private Bitmap clearBlank(Bitmap bp, int blank) {
        int x;
        boolean isStop;
        int y;
        int HEIGHT = bp.getHeight();
        int WIDTH = bp.getWidth();
        int top = 0;
        int left = 0;
        int right = 0;
        int bottom = 0;
        int[] pixs = new int[WIDTH];
        for (y = 0; y < HEIGHT; ++y) {
            bp.getPixels(pixs, 0, WIDTH, 0, y, WIDTH, 1);
            isStop = false;
            for (int pix : pixs) {
                if (pix == this.mBackColor) continue;
                top = y;
                isStop = true;
                break;
            }
            if (isStop) break;
        }
        for (y = HEIGHT - 1; y >= 0; --y) {
            bp.getPixels(pixs, 0, WIDTH, 0, y, WIDTH, 1);
            isStop = false;
            for (int pix : pixs) {
                if (pix == this.mBackColor) continue;
                bottom = y;
                isStop = true;
                break;
            }
            if (isStop) break;
        }
        pixs = new int[HEIGHT];
        for (x = 0; x < WIDTH; ++x) {
            bp.getPixels(pixs, 0, 1, x, 0, 1, HEIGHT);
            isStop = false;
            for (int pix : pixs) {
                if (pix == this.mBackColor) continue;
                left = x;
                isStop = true;
                break;
            }
            if (isStop) break;
        }
        for (x = WIDTH - 1; x > 0; --x) {
            bp.getPixels(pixs, 0, 1, x, 0, 1, HEIGHT);
            isStop = false;
            for (int pix : pixs) {
                if (pix == this.mBackColor) continue;
                right = x;
                isStop = true;
                break;
            }
            if (isStop) break;
        }
        if (blank < 0) {
            blank = 0;
        }
        left = left - blank > 0 ? left - blank : 0;
        top = top - blank > 0 ? top - blank : 0;
        right = right + blank > WIDTH - 1 ? WIDTH - 1 : right + blank;
        bottom = bottom + blank > HEIGHT - 1 ? HEIGHT - 1 : bottom + blank;
        return Bitmap.createBitmap((Bitmap)bp, (int)left, (int)top, (int)(right - left), (int)(bottom - top));
    }

    public void setPaintWidth(int mPaintWidth) {
        this.mPaintWidth = mPaintWidth = mPaintWidth > 0 ? mPaintWidth : 10;
        this.mGesturePaint.setStrokeWidth((float)mPaintWidth);
    }

    public void setBackColor(@ColorInt int backColor) {
        this.mBackColor = backColor;
    }

    public void setPenColor(int mPenColor) {
        this.mPenColor = mPenColor;
        this.mGesturePaint.setColor(mPenColor);
    }

    public boolean getTouched() {
        return this.isTouched;
    }
}

