/*
 * Decompiled with CFR 0.152.
 */
package com.byh.module.onlineoutser.im.utils;

import android.app.Application;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import com.blankj.utilcode.util.Utils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0002J\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bJ\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004\u00a8\u0006\u0010"}, d2={"Lcom/byh/module/onlineoutser/im/utils/UiUtil;", "", "()V", "calculateInSampleSize", "", "options", "Landroid/graphics/BitmapFactory$Options;", "reqWidth", "reqHeight", "dpToPx", "dp", "", "getSmallBitmap", "Landroid/graphics/Bitmap;", "filePath", "", "module_common_release"})
public final class UiUtil {
    public static final UiUtil INSTANCE;

    public final int dpToPx(float dp) {
        Application application = Utils.getApp();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"Utils.getApp()");
        Resources resources = application.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"Utils.getApp().resources");
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)resources.getDisplayMetrics());
    }

    @NotNull
    public final Bitmap getSmallBitmap(@NotNull String filePath, int reqWidth, int reqHeight) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
        options.inSampleSize = this.calculateInSampleSize(options, reqWidth, reqHeight);
        options.inJustDecodeBounds = false;
        Bitmap bitmap = BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"BitmapFactory.decodeFile(filePath, options)");
        return bitmap;
    }

    private final int calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            int widthRatio;
            int heightRatio = Math.round((float)height / (float)reqHeight);
            inSampleSize = heightRatio < (widthRatio = Math.round((float)width / (float)reqWidth)) ? heightRatio : widthRatio;
        }
        return inSampleSize;
    }

    private UiUtil() {
    }

    static {
        UiUtil uiUtil;
        INSTANCE = uiUtil = new UiUtil();
    }
}

