/*
 * Decompiled with CFR 0.152.
 */
package com.byh.module.onlineoutser.im.view;

import android.content.Context;
import android.graphics.Color;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.annotation.Nullable;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.byh.module.onlineoutser.im.utils.UiUtil;
import com.byh.module.onlineoutser.im.view.AdaptionPager;
import com.byh.module.onlineoutser.im.view.ColorPointHintView;
import com.byh.module.onlineoutser.im.view.FuncPanel;
import java.util.ArrayList;
import java.util.List;

public class ExFuncPager
extends LinearLayout {
    private ViewPager mPager;
    private SparseArray<FuncPanel> mViews;
    private ColorPointHintView mHintView;
    private FuncPanel.ItemClickListener mItemClickListener;

    public ExFuncPager(Context context) {
        this(context, null);
    }

    public ExFuncPager(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ExFuncPager(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setVisibility(8);
        this.setOrientation(1);
        this.setBackgroundColor(Color.parseColor((String)"#F0F0F0"));
        this.mPager = new AdaptionPager(context);
        this.addView((View)this.mPager, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, UiUtil.INSTANCE.dpToPx(210.0f)));
        this.mHintView = new ColorPointHintView(this.getContext(), Color.parseColor((String)"#E3AC42"), Color.parseColor((String)"#dddcdc"));
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
        params.bottomMargin = UiUtil.INSTANCE.dpToPx(5.0f);
        this.addView((View)this.mHintView, (ViewGroup.LayoutParams)params);
        this.mPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageSelected(int position) {
                ExFuncPager.this.mHintView.setCurrent(position);
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
    }

    public void setData(List<FuncPanel.Item> datas) {
        ArrayList<List<FuncPanel.Item>> pagerDatas = new ArrayList<List<FuncPanel.Item>>();
        int page = (int)Math.ceil((double)datas.size() / 8.0);
        for (int i = 0; i < page; ++i) {
            List<FuncPanel.Item> items = i == page - 1 ? datas.subList(i * 8, datas.size()) : datas.subList(i * 8, (i + 1) * 8);
            pagerDatas.add(items);
        }
        this.mPager.setAdapter((PagerAdapter)new MyAdapter(pagerDatas));
        if (pagerDatas.size() == 1) {
            this.mHintView.setVisibility(8);
        } else {
            this.mHintView.setVisibility(0);
            this.mHintView.initView(pagerDatas.size(), 1);
        }
    }

    public void setItemClickListener(FuncPanel.ItemClickListener itemClickListener) {
        this.mItemClickListener = itemClickListener;
    }

    public void show(Boolean show) {
        if (show.booleanValue()) {
            this.setVisibility(0);
        } else {
            this.setVisibility(8);
        }
    }

    public boolean isShow() {
        return this.getVisibility() == 0;
    }

    private class MyAdapter
    extends PagerAdapter {
        private List<List<FuncPanel.Item>> datas;

        public MyAdapter(List<List<FuncPanel.Item>> datas) {
            this.datas = datas;
        }

        public int getCount() {
            return this.datas.size();
        }

        public boolean isViewFromObject(View view, Object object) {
            return view == object;
        }

        public Object instantiateItem(ViewGroup container, int position) {
            FuncPanel panel;
            if (ExFuncPager.this.mViews == null) {
                ExFuncPager.this.mViews = new SparseArray();
            }
            if ((panel = (FuncPanel)((Object)ExFuncPager.this.mViews.get(position))) == null) {
                panel = new FuncPanel(ExFuncPager.this.getContext());
                LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
                panel.setLayoutParams((ViewGroup.LayoutParams)params);
                panel.setOnItemClickListener(ExFuncPager.this.mItemClickListener);
                ExFuncPager.this.mViews.put(position, (Object)panel);
            }
            panel.setDatas(this.datas.get(position));
            container.addView((View)panel);
            return panel;
        }

        public void destroyItem(ViewGroup container, int position, Object object) {
            container.removeView((View)ExFuncPager.this.mViews.get(position));
        }
    }
}

