/*
 * Decompiled with CFR 0.152.
 */
package com.byh.module.onlineoutser.im.view;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import cn.finalteam.galleryfinal.widget.zoonview.PhotoView;
import cn.finalteam.galleryfinal.widget.zoonview.PhotoViewAttacher;
import com.byh.module.onlineoutser.im.utils.ImgUtil;
import java.util.List;

public class ImagePreviewView
extends ViewPager {
    private List<String> mDatas;
    private ImageAdapter mAdapter;
    private ViewStateListener mListener;

    public ImagePreviewView(@NonNull Context context) {
        this(context, null);
    }

    public ImagePreviewView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.setBackgroundColor(-16777216);
    }

    public void setDatas(List<String> url) {
        this.mDatas = url;
        this.setAdapter();
    }

    public void setDatas(List<String> url, int index) {
        this.mDatas = url;
        this.setAdapter();
        this.setCurrentItem(index);
    }

    public void setListener(ViewStateListener mListener) {
        this.mListener = mListener;
    }

    public void show(boolean b) {
        if (b) {
            this.setVisibility(0);
            ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
            animator.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
            animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator valueAnimator) {
                    float rate = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                    ImagePreviewView.this.setAlpha(rate);
                    ImagePreviewView.this.setScaleX(rate);
                    ImagePreviewView.this.setScaleY(rate);
                }
            });
            animator.setDuration(300L);
            animator.setTarget((Object)this);
            animator.start();
            if (this.mListener != null) {
                this.mListener.onShow();
            }
        } else {
            ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.0f});
            animator.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
            animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator valueAnimator) {
                    float rate = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                    ImagePreviewView.this.setAlpha(rate);
                    ImagePreviewView.this.setScaleX(rate);
                    ImagePreviewView.this.setScaleY(rate);
                }
            });
            animator.setDuration(300L);
            animator.setTarget((Object)this);
            animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    if (ImagePreviewView.this.mListener != null) {
                        ImagePreviewView.this.mListener.onDismiss();
                    }
                    ImagePreviewView.this.setVisibility(8);
                }
            });
            animator.start();
        }
    }

    public String getCurrentImage() {
        if (this.mDatas != null) {
            return this.mDatas.get(this.getCurrentItem());
        }
        return "";
    }

    private void setAdapter() {
        if (this.mAdapter == null) {
            this.mAdapter = new ImageAdapter(this.getContext(), this.mDatas);
            this.setAdapter(this.mAdapter);
        } else {
            this.mAdapter.setDatas(this.mDatas);
        }
    }

    public boolean onBack() {
        if (this.getVisibility() == 0) {
            this.show(false);
            return true;
        }
        return false;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        try {
            return super.onInterceptTouchEvent(ev);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return false;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        try {
            return super.onTouchEvent(ev);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    class ImageAdapter
    extends PagerAdapter {
        private Context mContext;
        private List<String> mDatas;

        public ImageAdapter(Context mContext, List<String> mDatas) {
            this.mContext = mContext;
            this.mDatas = mDatas;
        }

        public void setDatas(List<String> data) {
            this.mDatas = data;
            this.notifyDataSetChanged();
        }

        public int getCount() {
            return this.mDatas.size();
        }

        public boolean isViewFromObject(@NonNull View view, @NonNull Object object) {
            return view == object;
        }

        @NonNull
        public Object instantiateItem(@NonNull ViewGroup container, int position) {
            PhotoView view = new PhotoView(this.mContext);
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
            view.setLayoutParams((ViewGroup.LayoutParams)params);
            view.setScaleType(ImageView.ScaleType.FIT_CENTER);
            ImgUtil.load(this.mDatas.get(position), (ImageView)view);
            view.setOnViewTapListener(new PhotoViewAttacher.OnViewTapListener(){

                public void onViewTap(View view, float x, float y) {
                    ImagePreviewView.this.show(false);
                }
            });
            container.addView((View)view);
            return view;
        }

        public void destroyItem(@NonNull ViewGroup container, int position, @NonNull Object object) {
            container.removeView((View)object);
        }
    }

    public static interface ViewStateListener {
        public void onShow();

        public void onDismiss();
    }
}

