/*
 * Decompiled with CFR 0.152.
 */
package com.byh.module.onlineoutser.im.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;

public class LoadingView
extends View {
    private Paint mPaint;
    private int mWidth;
    private int mHeight;
    private int mLineCount = 12;
    private double mPerDegree;
    private int mDuration = 450;
    private int mInvalidateTime;
    private long mCurrentTime;

    public LoadingView(Context context, AttributeSet attrs) {
        super(context, attrs);
        float density = context.getResources().getDisplayMetrics().density;
        this.mPaint = new Paint(1);
        this.mPaint.setColor(-1);
        this.mPaint.setStrokeWidth(1.5f * density);
        this.mPerDegree = Math.PI * 2 / (double)this.mLineCount;
        this.mInvalidateTime = this.mDuration / this.mLineCount;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mWidth = w;
        this.mHeight = h;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        float halfW = (float)this.mWidth / 2.0f;
        canvas.translate(halfW, (float)this.mHeight / 2.0f);
        for (int i = 0; i < this.mLineCount; ++i) {
            float half = halfW / 2.0f;
            double degree = (double)i * this.mPerDegree + this.mPerDegree * (double)this.mCurrentTime / (double)this.mInvalidateTime;
            float startX = (float)((double)half * Math.sin(degree));
            float startY = (float)((double)half * Math.cos(degree));
            this.mPaint.setColor(Color.argb((int)((int)(255.0f * (1.0f - (float)i * 1.0f / 1.25f / (float)this.mLineCount))), (int)255, (int)255, (int)255));
            canvas.drawLine(startX, startY, (float)((double)halfW * Math.sin(degree)), (float)((double)halfW * Math.cos(degree)), this.mPaint);
        }
        this.postInvalidateDelayed(this.mInvalidateTime);
        this.mCurrentTime += (long)this.mInvalidateTime;
    }
}

