/*
 * Decompiled with CFR 0.152.
 */
package com.byh.module.onlineoutser.im.view;

import android.os.Handler;
import android.view.View;
import android.widget.ImageView;
import android.widget.PopupWindow;
import android.widget.TextView;
import com.kangxin.common.R;
import com.kangxin.common.util.StringsUtils;

public class RecordPopupWindow
extends PopupWindow {
    public static final int IDLE = 0;
    public static final int PREPARE = 1;
    public static final int RECORDING = 2;
    public static final int CANCEL = 3;
    public static final int TOO_SHORT = 4;
    public static final int ON_TICK = 5;
    public static final int ON_MAX = 6;
    private static final int[] ampIcon = new int[]{R.drawable.online_amp1, R.drawable.online_amp2, R.drawable.online_amp3, R.drawable.online_amp4, R.drawable.online_amp5, R.drawable.online_amp6, R.drawable.online_amp7};
    private View mVoiceHintAnimArea;
    private View mVoiceRcdHitCancelView;
    private View mTickRoot;
    private TextView mVoiceHintCancelText;
    private ImageView mVoiceHintCancelIcon;
    private View mVoiceHintLoading;
    private View mVoiceHintTooshort;
    private TextView mVoiceNormalWording;
    private TextView mWarning;
    private TextView mTicker;
    private ImageView mVoiceHintAnim;
    private int mCurrentStatus;
    private int mDestinAmp;
    private int mCurrentAmp = 0;
    private boolean mRunning;
    private Handler mHandler;
    private Runnable mUpdate = new Runnable(){

        @Override
        public void run() {
            RecordPopupWindow.this.mVoiceHintAnim.setBackgroundResource(ampIcon[RecordPopupWindow.this.mCurrentAmp]);
            if (RecordPopupWindow.this.mCurrentAmp == RecordPopupWindow.this.mDestinAmp) {
                RecordPopupWindow.this.mRunning = false;
                return;
            }
            if (RecordPopupWindow.this.mCurrentAmp < RecordPopupWindow.this.mDestinAmp) {
                RecordPopupWindow.this.mCurrentAmp++;
            } else {
                RecordPopupWindow.this.mCurrentAmp--;
            }
            RecordPopupWindow.this.mHandler.postDelayed((Runnable)this, 20L);
        }
    };

    public RecordPopupWindow(View contentView, int width, int height) {
        super(contentView, width, height, false);
        this.mVoiceHintAnim = (ImageView)this.getContentView().findViewById(R.id.voice_rcd_hint_anim);
        this.mVoiceHintAnimArea = this.getContentView().findViewById(R.id.voice_rcd_hint_anim_area);
        this.mVoiceRcdHitCancelView = this.getContentView().findViewById(R.id.voice_rcd_hint_cancel_area);
        this.mVoiceHintCancelText = (TextView)this.getContentView().findViewById(R.id.voice_rcd_hint_cancel_text);
        this.mVoiceHintCancelIcon = (ImageView)this.getContentView().findViewById(R.id.voice_rcd_hint_cancel_icon);
        this.mVoiceHintLoading = this.getContentView().findViewById(R.id.voice_rcd_hint_loading);
        this.mVoiceHintTooshort = this.getContentView().findViewById(R.id.voice_rcd_hint_tooshort);
        this.mVoiceNormalWording = (TextView)this.getContentView().findViewById(R.id.voice_rcd_normal_wording);
        this.mWarning = (TextView)this.getContentView().findViewById(R.id.warning);
        this.mTickRoot = this.getContentView().findViewById(R.id.tick_root);
        this.mTicker = (TextView)this.getContentView().findViewById(R.id.ticker);
    }

    public void displayAmplitude(int amplitude) {
        this.mDestinAmp = amplitude;
        if (this.mDestinAmp > ampIcon.length - 1) {
            this.mDestinAmp = ampIcon.length - 1;
        }
        if (this.mHandler == null) {
            this.mHandler = new Handler();
        }
        if (!this.mRunning) {
            this.mHandler.post(this.mUpdate);
            this.mRunning = true;
        }
    }

    public void updateTick(int tick) {
        this.mTicker.setText((CharSequence)String.valueOf(tick));
    }

    public void switchStatus(int status) {
        if (this.mCurrentStatus == 5 && status == 2) {
            return;
        }
        switch (status) {
            case 0: 
            case 2: {
                this.mVoiceHintAnimArea.setVisibility(0);
                this.mVoiceRcdHitCancelView.setVisibility(8);
                this.mVoiceHintLoading.setVisibility(8);
                this.mVoiceHintTooshort.setVisibility(8);
                this.mTickRoot.setVisibility(8);
                break;
            }
            case 1: {
                this.mVoiceHintLoading.setVisibility(0);
                this.mVoiceHintAnimArea.setVisibility(8);
                this.mVoiceRcdHitCancelView.setVisibility(8);
                this.mVoiceHintTooshort.setVisibility(8);
                this.mTickRoot.setVisibility(8);
                break;
            }
            case 3: {
                this.mVoiceHintAnimArea.setVisibility(8);
                this.mVoiceRcdHitCancelView.setVisibility(0);
                this.mVoiceHintLoading.setVisibility(8);
                this.mVoiceHintTooshort.setVisibility(8);
                this.mTickRoot.setVisibility(8);
                break;
            }
            case 4: {
                this.mVoiceHintAnimArea.setVisibility(8);
                this.mVoiceRcdHitCancelView.setVisibility(8);
                this.mVoiceHintLoading.setVisibility(8);
                this.mVoiceHintTooshort.setVisibility(0);
                this.mTickRoot.setVisibility(8);
                this.mWarning.setText((CharSequence)StringsUtils.getString(R.string.onlineoutser_luyinshijiantaiduan));
                break;
            }
            case 6: {
                this.mVoiceHintAnimArea.setVisibility(8);
                this.mVoiceRcdHitCancelView.setVisibility(8);
                this.mVoiceHintLoading.setVisibility(8);
                this.mVoiceHintTooshort.setVisibility(8);
                this.mTickRoot.setVisibility(8);
                this.mWarning.setText((CharSequence)StringsUtils.getString(R.string.onlineoutser_luyinchaoshi));
                break;
            }
            case 5: {
                this.mVoiceHintAnimArea.setVisibility(8);
                this.mVoiceRcdHitCancelView.setVisibility(8);
                this.mVoiceHintLoading.setVisibility(8);
                this.mVoiceHintTooshort.setVisibility(8);
                this.mTickRoot.setVisibility(0);
            }
        }
        this.mCurrentStatus = status;
    }

    public int getStatus() {
        return this.mCurrentStatus;
    }
}

