/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.module_bothreferral.decorate;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.LayoutRes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

public class ShareMultiDelegate {
    FrameLayout rootView;
    @SuppressLint(value={"UseSparseArrays"})
    HashMap<Integer, Build> buildMap = new HashMap();
    @SuppressLint(value={"UseSparseArrays"})
    HashMap<Integer, Integer> typeMap = new HashMap();
    @SuppressLint(value={"UseSparseArrays"})
    HashMap<Integer, View> reuseMap = new HashMap();
    Set<Integer> receptType = new TreeSet<Integer>();
    Build lastBuild = null;
    boolean isLazyLoad = true;
    boolean isReuseLayout = true;
    int defaultType = -1;
    int currentType = -1;

    private ShareMultiDelegate(FrameLayout controlView) {
        this.rootView = controlView;
    }

    public static ShareMultiDelegate getInstance(FrameLayout controlView) {
        return new ShareMultiDelegate(controlView);
    }

    public Build registerView(int type, @LayoutRes int layoutId) {
        Build build2 = Build.create(this, layoutId, type);
        this.typeMap.put(type, layoutId);
        this.buildMap.put(type, build2);
        return build2;
    }

    public ShareMultiDelegate isLazyLoad(boolean isLazyLoad) {
        this.isLazyLoad = isLazyLoad;
        return this;
    }

    public ShareMultiDelegate setDefault(int type) {
        this.defaultType = type;
        return this;
    }

    public ShareMultiDelegate isReuseLayout(boolean isReuseLayout) {
        this.isReuseLayout = isReuseLayout;
        return this;
    }

    public void go() {
        this.creatReceptType();
        this.loadView();
        this.switchType(this.defaultType);
    }

    private void loadView() {
        if (this.buildMap.size() == 0) {
            return;
        }
        if (this.isLazyLoad) {
            if (this.defaultType == -1) {
                ArrayList<Integer> keyList = new ArrayList<Integer>(this.buildMap.keySet());
                Build build2 = this.buildMap.get(keyList.get(0));
                if (build2 == null || build2.contentLayout == 0) {
                    return;
                }
                this.inflate(build2);
            } else {
                Build build3 = this.buildMap.get(this.defaultType);
                if (build3 == null || build3.contentLayout == 0) {
                    return;
                }
                this.inflate(build3);
            }
        } else {
            for (Integer key : this.buildMap.keySet()) {
                Build build4 = this.buildMap.get(key);
                if (build4 == null || build4.contentLayout == 0) continue;
                this.inflate(build4);
            }
        }
    }

    private void inflate(Build build2) {
        if (!this.isReuseLayout) {
            View view = LayoutInflater.from((Context)this.rootView.getContext()).inflate(build2.contentLayout, (ViewGroup)this.rootView, false);
            this.rootView.addView(view);
            build2.bindInstanceView(view);
            build2.init.bindView((View)this.rootView);
            return;
        }
        if (this.reuseMap.get(build2.contentLayout) == null) {
            View view = LayoutInflater.from((Context)this.rootView.getContext()).inflate(build2.contentLayout, (ViewGroup)this.rootView, false);
            this.rootView.addView(view);
            this.reuseMap.put(build2.contentLayout, view);
            build2.bindInstanceView(view);
            build2.init.bindView((View)this.rootView);
        } else {
            build2.bindInstanceView(this.reuseMap.get(build2.contentLayout));
            build2.init.bindView((View)this.rootView);
        }
    }

    private void decisionView(int type) {
        Build build2;
        for (int key : this.buildMap.keySet()) {
            Build build3 = this.buildMap.get(key);
            if (build3 == null || build3.view == null) continue;
            build3.view.setVisibility(4);
        }
        if (this.lastBuild != null && this.lastBuild.lifeListener != null) {
            this.lastBuild.lifeListener.onHide(this.lastBuild.view);
        }
        if ((build2 = this.buildMap.get(type)) == null) {
            return;
        }
        if (build2.view == null) {
            this.inflate(build2);
            build2.init.init(build2.view);
            build2.isInit = true;
        } else if (this.isReuseLayout) {
            if (this.receptType.contains(build2.type)) {
                build2.init.init(build2.view);
            } else if (!build2.isInit) {
                build2.init.init(build2.view);
                build2.isInit = true;
            }
        } else if (!build2.isInit) {
            build2.init.init(build2.view);
            build2.isInit = true;
        }
        build2.view.setVisibility(0);
        if (build2.lifeListener != null) {
            build2.lifeListener.onVisiable(build2.view);
        }
        this.lastBuild = build2;
    }

    private void creatReceptType() {
        if (this.buildMap == null || this.buildMap.keySet().size() == 0) {
            return;
        }
        HashMap<Integer, Integer> copy = new HashMap<Integer, Integer>(this.typeMap);
        for (Map.Entry<Integer, Integer> entry : this.typeMap.entrySet()) {
            copy.remove(entry.getKey());
            if (copy.containsValue(entry.getValue())) {
                this.receptType.add(entry.getKey());
            }
            copy.put(entry.getKey(), entry.getValue());
        }
    }

    public void switchType(int type) {
        this.currentType = type;
        this.decisionView(type);
    }

    public View getView(int type) {
        if (this.buildMap.get(type) != null) {
            return Objects.requireNonNull(this.buildMap.get((Object)Integer.valueOf((int)type))).view;
        }
        return null;
    }

    public static class Build {
        int contentLayout;
        ShareMultiDelegate delegate;
        View view;
        int type;
        boolean isInit;
        Init init;
        LifeListener lifeListener;

        private Build(ShareMultiDelegate delegate, @LayoutRes int layout, int type) {
            this.delegate = delegate;
            this.contentLayout = layout;
            this.type = type;
        }

        private static Build create(ShareMultiDelegate delegate, @LayoutRes int layout, int type) {
            return new Build(delegate, layout, type);
        }

        public Build init(Init init) {
            this.init = init;
            return this;
        }

        public Build bindLifeListener(LifeListener lifeListener) {
            this.lifeListener = lifeListener;
            return this;
        }

        public ShareMultiDelegate complete() {
            return this.delegate;
        }

        private void bindInstanceView(View view) {
            this.view = view;
        }
    }

    public static interface LifeListener {
        public void onVisiable(View var1);

        public void onHide(View var1);
    }

    public static interface Init {
        public void init(View var1);

        public void bindView(View var1);
    }
}

