/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.module_bothreferral.decorate;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.kangxin.common.R;

public class TiStarView
extends LinearLayout {
    private String title;
    private Boolean isStar;
    private TextView ts;
    private TextView t;

    public TiStarView(Context context) {
        super(context);
    }

    public TiStarView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public TiStarView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, @Nullable AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.TiStarView);
        this.title = typedArray.getString(R.styleable.TiStarView_titleName);
        this.isStar = typedArray.getBoolean(R.styleable.TiStarView_hasStar, false);
        typedArray.recycle();
        this.setGravity(16);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.tistar_view_layout, (ViewGroup)this);
        this.t = (TextView)this.findViewById(R.id.title);
        this.t.setText((CharSequence)this.title);
        this.ts = (TextView)this.findViewById(R.id.star);
        if (this.isStar.booleanValue()) {
            this.ts.setVisibility(0);
        } else {
            this.ts.setVisibility(4);
        }
    }

    public TiStarView setIsStar(boolean isStar) {
        this.isStar = isStar;
        if (this.ts != null) {
            if (isStar) {
                this.ts.setVisibility(0);
            } else {
                this.ts.setVisibility(4);
            }
        }
        return this;
    }

    public TiStarView setTitle(String titleStr) {
        this.title = titleStr;
        if (this.t != null) {
            this.t.setText((CharSequence)titleStr);
        }
        return this;
    }
}

