/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.framework;

import android.content.Context;
import android.os.Environment;
import android.util.Log;
import androidx.core.content.ContextCompat;
import cn.finalteam.galleryfinal.CoreConfig;
import cn.finalteam.galleryfinal.FunctionConfig;
import cn.finalteam.galleryfinal.GalleryFinal;
import cn.finalteam.galleryfinal.ImageLoader;
import cn.finalteam.galleryfinal.ThemeConfig;
import cn.finalteam.galleryfinal.model.PhotoInfo;
import com.kangxin.common.R;
import com.kangxin.common.framework.ImageSelector;
import com.kangxin.common.imageloader.GalleryImageLoader;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class GalleryFinalSelector
implements ImageSelector {
    public static final int REQUEST_CODE_GALLERY = 5392;
    public static final int REQUEST_CODE_CAMERA = 5393;
    String TAG = "GalleryFinalSelector";

    @Override
    public void init(Context context) {
        ThemeConfig theme = new ThemeConfig.Builder().setTitleBarBgColor(ContextCompat.getColor((Context)context, (int)R.color.colorPrimary)).setCheckSelectedColor(ContextCompat.getColor((Context)context, (int)R.color.colorPrimary)).setFabNornalColor(ContextCompat.getColor((Context)context, (int)R.color.colorPrimary)).setFabPressedColor(ContextCompat.getColor((Context)context, (int)R.color.colorPrimary)).build();
        FunctionConfig functionConfig = new FunctionConfig.Builder().setEnableCamera(true).setEnableEdit(false).setEnableCrop(false).setEnableRotate(false).setCropSquare(true).setEnablePreview(false).build();
        String sdcard = Environment.getExternalStorageDirectory().getPath();
        File file = new File(sdcard + "/DCIM/");
        GalleryImageLoader imageloader = new GalleryImageLoader();
        CoreConfig coreConfig = new CoreConfig.Builder(context, (ImageLoader)imageloader, theme).setFunctionConfig(functionConfig).setTakePhotoFolder(file).build();
        GalleryFinal.init((CoreConfig)coreConfig);
    }

    @Override
    public void openCameraSingle(final ImageSelector.OnImageSelectedListener listener2) {
        GalleryFinal.openCamera((int)5393, (GalleryFinal.OnHanlderResultCallback)new GalleryFinal.OnHanlderResultCallback(){

            public void onHanlderSuccess(int reqeustCode, List<PhotoInfo> resultList) {
                if (listener2 != null) {
                    if (resultList != null && resultList.size() > 0) {
                        String photoPath = resultList.get(0).getPhotoPath();
                        listener2.onSelectedImages(photoPath);
                    } else {
                        Log.e((String)GalleryFinalSelector.this.TAG, (String)"\u56fe\u7247\u83b7\u53d6\u5931\u8d25\u4e86\uff0c\u53ef\u80fd\u662f\u6ca1\u6709\u9009\u62e9\u56fe\u7247\u5427");
                    }
                } else {
                    Log.e((String)GalleryFinalSelector.this.TAG, (String)"\u4e8b\u4ef6\u76d1\u542c\u4e3anull \u6709\u70b9\u95ee\u9898");
                }
            }

            public void onHanlderFailure(int requestCode, String errorMsg) {
                Log.e((String)GalleryFinalSelector.this.TAG, (String)"errorMsg");
            }
        });
    }

    @Override
    public void openAlbumSingle(final ImageSelector.OnImageSelectedListener listener2) {
        GalleryFinal.openGallerySingle((int)5392, (GalleryFinal.OnHanlderResultCallback)new GalleryFinal.OnHanlderResultCallback(){

            public void onHanlderSuccess(int reqeustCode, List<PhotoInfo> resultList) {
                if (listener2 != null) {
                    if (resultList != null && resultList.size() > 0) {
                        String photoPath = resultList.get(0).getPhotoPath();
                        listener2.onSelectedImages(photoPath);
                    } else {
                        Log.e((String)GalleryFinalSelector.this.TAG, (String)"\u56fe\u7247\u83b7\u53d6\u5931\u8d25\u4e86\uff0c\u53ef\u80fd\u662f\u6ca1\u6709\u9009\u62e9\u56fe\u7247\u5427");
                    }
                } else {
                    Log.e((String)GalleryFinalSelector.this.TAG, (String)"\u4e8b\u4ef6\u76d1\u542c\u4e3anull \u6709\u70b9\u95ee\u9898");
                }
            }

            public void onHanlderFailure(int requestCode, String errorMsg) {
                Log.e((String)GalleryFinalSelector.this.TAG, (String)"errorMsg");
            }
        });
    }

    @Override
    public void openAlbumMany(final ImageSelector.OnImagesSelectedListener listener2) {
        final boolean[] isClickSelbtn = new boolean[]{false};
        GalleryFinal.openGalleryMuti((int)5392, (int)9, (GalleryFinal.OnHanlderResultCallback)new GalleryFinal.OnHanlderResultCallback(){

            public void onHanlderSuccess(int reqeustCode, List<PhotoInfo> resultList) {
                if (listener2 != null) {
                    if (resultList != null && resultList.size() > 0) {
                        if (!isClickSelbtn[0]) {
                            ArrayList<String> images = new ArrayList<String>();
                            for (PhotoInfo info : resultList) {
                                images.add(info.getPhotoPath());
                            }
                            listener2.onSelectedImages(images);
                            isClickSelbtn[0] = true;
                        }
                    } else {
                        Log.e((String)GalleryFinalSelector.this.TAG, (String)"\u56fe\u7247\u83b7\u53d6\u5931\u8d25\u4e86\uff0c\u53ef\u80fd\u662f\u6ca1\u6709\u9009\u62e9\u56fe\u7247\u5427");
                    }
                } else {
                    Log.e((String)GalleryFinalSelector.this.TAG, (String)"\u4e8b\u4ef6\u76d1\u542c\u4e3anull \u6709\u70b9\u95ee\u9898");
                }
            }

            public void onHanlderFailure(int requestCode, String errorMsg) {
                Log.e((String)GalleryFinalSelector.this.TAG, (String)"errorMsg");
            }
        });
    }
}

