/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.guide.model;

import android.graphics.RectF;
import android.view.View;
import android.view.animation.Animation;
import androidx.annotation.ColorInt;
import androidx.annotation.LayoutRes;
import androidx.annotation.Nullable;
import com.kangxin.common.guide.listener.OnHighlightDrewListener;
import com.kangxin.common.guide.listener.OnLayoutInflatedListener;
import com.kangxin.common.guide.model.HighLight;
import com.kangxin.common.guide.model.HighlightOptions;
import com.kangxin.common.guide.model.HighlightRectF;
import com.kangxin.common.guide.model.HighlightView;
import com.kangxin.common.guide.model.RelativeGuide;
import java.util.ArrayList;
import java.util.List;

public class GuidePage {
    private List<HighLight> highLights = new ArrayList<HighLight>();
    private boolean everywhereCancelable = true;
    private int backgroundColor;
    private int layoutResId;
    private int[] clickToDismissIds;
    private OnLayoutInflatedListener onLayoutInflatedListener;
    private OnHighlightDrewListener onHighlightDrewListener;
    private Animation enterAnimation;
    private Animation exitAnimation;

    public static GuidePage newInstance() {
        return new GuidePage();
    }

    public GuidePage addHighLight(View view) {
        return this.addHighLight(view, HighLight.Shape.RECTANGLE, 0, 0, null);
    }

    public GuidePage addHighLight(View view, RelativeGuide relativeGuide) {
        return this.addHighLight(view, HighLight.Shape.RECTANGLE, 0, 0, relativeGuide);
    }

    public GuidePage addHighLight(View view, HighLight.Shape shape) {
        return this.addHighLight(view, shape, 0, 0, null);
    }

    public GuidePage addHighLight(View view, HighLight.Shape shape, RelativeGuide relativeGuide) {
        return this.addHighLight(view, shape, 0, 0, relativeGuide);
    }

    public GuidePage addHighLight(View view, HighLight.Shape shape, int padding) {
        return this.addHighLight(view, shape, 0, padding, null);
    }

    public GuidePage addHighLight(View view, HighLight.Shape shape, int padding, RelativeGuide relativeGuide) {
        return this.addHighLight(view, shape, 0, padding, relativeGuide);
    }

    public GuidePage addHighLight(View view, HighLight.Shape shape, int round, int padding, @Nullable RelativeGuide relativeGuide) {
        HighlightView highlight = new HighlightView(view, shape, round, padding);
        if (relativeGuide != null) {
            relativeGuide.highLight = highlight;
            highlight.setOptions(new HighlightOptions.Builder().setRelativeGuide(relativeGuide).build());
        }
        this.highLights.add(highlight);
        return this;
    }

    public GuidePage addHighLight(RectF rectF) {
        return this.addHighLight(rectF, HighLight.Shape.RECTANGLE, 0, null);
    }

    public GuidePage addHighLight(RectF rectF, RelativeGuide relativeGuide) {
        return this.addHighLight(rectF, HighLight.Shape.RECTANGLE, 0, relativeGuide);
    }

    public GuidePage addHighLight(RectF rectF, HighLight.Shape shape) {
        return this.addHighLight(rectF, shape, 0, null);
    }

    public GuidePage addHighLight(RectF rectF, HighLight.Shape shape, RelativeGuide relativeGuide) {
        return this.addHighLight(rectF, shape, 0, relativeGuide);
    }

    public GuidePage addHighLight(RectF rectF, HighLight.Shape shape, int round) {
        return this.addHighLight(rectF, shape, round, null);
    }

    public GuidePage addHighLight(RectF rectF, HighLight.Shape shape, int round, RelativeGuide relativeGuide) {
        HighlightRectF highlight = new HighlightRectF(rectF, shape, round);
        if (relativeGuide != null) {
            relativeGuide.highLight = highlight;
            highlight.setOptions(new HighlightOptions.Builder().setRelativeGuide(relativeGuide).build());
        }
        this.highLights.add(highlight);
        return this;
    }

    public GuidePage addHighLightWithOptions(View view, HighlightOptions options) {
        return this.addHighLightWithOptions(view, HighLight.Shape.RECTANGLE, 0, 0, options);
    }

    public GuidePage addHighLightWithOptions(View view, HighLight.Shape shape, HighlightOptions options) {
        return this.addHighLightWithOptions(view, shape, 0, 0, options);
    }

    public GuidePage addHighLightWithOptions(View view, HighLight.Shape shape, int round, int padding, HighlightOptions options) {
        HighlightView highlight = new HighlightView(view, shape, round, padding);
        if (options != null && options.relativeGuide != null) {
            options.relativeGuide.highLight = highlight;
        }
        highlight.setOptions(options);
        this.highLights.add(highlight);
        return this;
    }

    public GuidePage addHighLightWithOptions(RectF rectF, HighlightOptions options) {
        return this.addHighLightWithOptions(rectF, HighLight.Shape.RECTANGLE, 0, options);
    }

    public GuidePage addHighLightWithOptions(RectF rectF, HighLight.Shape shape, HighlightOptions options) {
        return this.addHighLightWithOptions(rectF, shape, 0, options);
    }

    public GuidePage addHighLightWithOptions(RectF rectF, HighLight.Shape shape, int round, HighlightOptions options) {
        HighlightRectF highlight = new HighlightRectF(rectF, shape, round);
        if (options != null && options.relativeGuide != null) {
            options.relativeGuide.highLight = highlight;
        }
        highlight.setOptions(options);
        this.highLights.add(highlight);
        return this;
    }

    public GuidePage setLayoutRes(@LayoutRes int resId, int ... id) {
        this.layoutResId = resId;
        this.clickToDismissIds = id;
        return this;
    }

    public GuidePage setEverywhereCancelable(boolean everywhereCancelable) {
        this.everywhereCancelable = everywhereCancelable;
        return this;
    }

    public GuidePage setBackgroundColor(@ColorInt int backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    public GuidePage setOnLayoutInflatedListener(OnLayoutInflatedListener onLayoutInflatedListener) {
        this.onLayoutInflatedListener = onLayoutInflatedListener;
        return this;
    }

    public GuidePage setEnterAnimation(Animation enterAnimation) {
        this.enterAnimation = enterAnimation;
        return this;
    }

    public GuidePage setExitAnimation(Animation exitAnimation) {
        this.exitAnimation = exitAnimation;
        return this;
    }

    public boolean isEverywhereCancelable() {
        return this.everywhereCancelable;
    }

    public boolean isEmpty() {
        return this.layoutResId == 0 && this.highLights.size() == 0;
    }

    public List<HighLight> getHighLights() {
        return this.highLights;
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public int getLayoutResId() {
        return this.layoutResId;
    }

    public int[] getClickToDismissIds() {
        return this.clickToDismissIds;
    }

    public OnLayoutInflatedListener getOnLayoutInflatedListener() {
        return this.onLayoutInflatedListener;
    }

    public Animation getEnterAnimation() {
        return this.enterAnimation;
    }

    public Animation getExitAnimation() {
        return this.exitAnimation;
    }

    public List<RelativeGuide> getRelativeGuides() {
        ArrayList<RelativeGuide> relativeGuides = new ArrayList<RelativeGuide>();
        for (HighLight highLight : this.highLights) {
            HighlightOptions options = highLight.getOptions();
            if (options == null || options.relativeGuide == null) continue;
            relativeGuides.add(options.relativeGuide);
        }
        return relativeGuides;
    }
}

