/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.http.factory;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.Converter;

public class GsonResponseBodyErrorConverter<T>
implements Converter<ResponseBody, T> {
    private final Gson gson;
    private final TypeAdapter<T> adapter;

    public GsonResponseBodyErrorConverter(Gson gson2, TypeAdapter<T> adapter) {
        this.gson = gson2;
        this.adapter = adapter;
    }

    public T convert(ResponseBody value) throws IOException {
        JsonObject json = (JsonObject)this.gson.fromJson(value.string(), JsonObject.class);
        if (!json.get("resultCode").equals("200")) {
            json.addProperty("data", "");
        }
        return (T)this.adapter.fromJson(json.toString());
    }
}

