/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.worktable.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.text.Editable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.kangxin.common.R;

public class ConsuApplySelItemView
extends RelativeLayout {
    private static final String TAG = "ConsuApplySelItemView";
    private TextView mLabelConsuView;
    private TextView mNothingTextView;
    private TextView mHasExitTextView;
    private EditText mEditConsuCaseView;
    private OnHasCaseDescListener onHasCaseDescListener;

    public ConsuApplySelItemView(Context context) {
        this(context, null);
    }

    public ConsuApplySelItemView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ConsuApplySelItemView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        LayoutInflater.from((Context)context).inflate(R.layout.worktab_consuapply_selitem, (ViewGroup)this);
        this.mLabelConsuView = (TextView)this.findViewById(R.id.caselabel_name);
        this.mNothingTextView = (TextView)this.findViewById(R.id.nothing_txt);
        this.mHasExitTextView = (TextView)this.findViewById(R.id.have_exist_txt);
        this.mEditConsuCaseView = (EditText)this.findViewById(R.id.edt_consu_info);
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.ConsuApplySelItemView);
        String labelConsuName = typedArray.getString(R.styleable.ConsuApplySelItemView_label_name_consu);
        String hintConsuDesc = typedArray.getString(R.styleable.ConsuApplySelItemView_hint_desc_consucase);
        boolean isShowExpand = typedArray.getBoolean(R.styleable.ConsuApplySelItemView_is_show_expand_edtconsu, false);
        typedArray.recycle();
        if (labelConsuName != null) {
            this.mLabelConsuView.setText((CharSequence)labelConsuName);
        }
        if (hintConsuDesc != null) {
            this.mEditConsuCaseView.setHint((CharSequence)hintConsuDesc);
        }
        this.expandEdtView(isShowExpand);
        this.mNothingTextView.setOnClickListener(v -> {
            this.expandEdtView(false);
            if (this.onHasCaseDescListener != null) {
                this.onHasCaseDescListener.onHasCaseDesc(false, this.mEditConsuCaseView.getText());
            }
        });
        this.mHasExitTextView.setOnClickListener(v -> {
            this.expandEdtView(true);
            if (this.onHasCaseDescListener != null) {
                this.onHasCaseDescListener.onHasCaseDesc(true, this.mEditConsuCaseView.getText());
            }
        });
    }

    public void setOnHasCaseDescListener(OnHasCaseDescListener onHasCaseDescListener) {
        this.onHasCaseDescListener = onHasCaseDescListener;
    }

    public Editable getContentText() {
        return this.mEditConsuCaseView.getText();
    }

    public void setContentText(String content) {
        this.mEditConsuCaseView.setText((CharSequence)content);
    }

    public void expandEdtView(boolean isExpand) {
        if (isExpand) {
            this.mNothingTextView.setTextColor(Color.parseColor((String)"#666666"));
            this.mHasExitTextView.setTextColor(Color.parseColor((String)"#3576E0"));
            this.mNothingTextView.setBackgroundResource(R.drawable.by_background_white_low);
            this.mHasExitTextView.setBackgroundResource(R.drawable.by_background_blue_low);
            this.mEditConsuCaseView.setVisibility(0);
        } else {
            this.mNothingTextView.setTextColor(Color.parseColor((String)"#3576E0"));
            this.mHasExitTextView.setTextColor(Color.parseColor((String)"#666666"));
            this.mNothingTextView.setBackgroundResource(R.drawable.by_background_blue_low);
            this.mHasExitTextView.setBackgroundResource(R.drawable.by_background_white_low);
            this.mEditConsuCaseView.setVisibility(8);
            this.mEditConsuCaseView.setText((CharSequence)"");
        }
    }

    public static interface OnHasCaseDescListener {
        public void onHasCaseDesc(boolean var1, Editable var2);
    }
}

