/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.utils;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import androidx.annotation.NonNull;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.resource.bitmap.BitmapTransformation;
import com.bumptech.glide.load.resource.bitmap.TransformationUtils;
import java.security.MessageDigest;
import org.jetbrains.annotations.NotNull;

public class GlideRoundTransform
extends BitmapTransformation {
    private static float radius = 0.0f;

    public GlideRoundTransform() {
        this(4);
    }

    public GlideRoundTransform(int dp) {
        radius = Resources.getSystem().getDisplayMetrics().density * (float)dp;
    }

    protected Bitmap transform(@NonNull BitmapPool pool, @NonNull Bitmap toTransform, int outWidth, int outHeight) {
        Bitmap bitmap = TransformationUtils.centerCrop((BitmapPool)pool, (Bitmap)toTransform, (int)outWidth, (int)outHeight);
        return GlideRoundTransform.roundCrop(pool, bitmap);
    }

    public void updateDiskCacheKey(@NotNull MessageDigest messageDigest) {
    }

    private static Bitmap roundCrop(BitmapPool pool, Bitmap source) {
        if (source == null) {
            return null;
        }
        Bitmap result = pool.get(source.getWidth(), source.getHeight(), Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(result);
        Paint paint = new Paint();
        paint.setShader((Shader)new BitmapShader(source, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP));
        paint.setAntiAlias(true);
        RectF rectF = new RectF(0.0f, 0.0f, (float)source.getWidth(), (float)source.getHeight());
        canvas.drawRoundRect(rectF, radius, radius, paint);
        return result;
    }
}

