package com.byh.lib.byhim.utils;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.style.DynamicDrawableSpan;
import android.text.style.ImageSpan;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.bumptech.glide.Glide;
import com.bumptech.glide.request.target.SimpleTarget;
import com.bumptech.glide.request.transition.Transition;

import java.lang.reflect.Field;


/**
 *
 */
public class UrlImageSpan extends ImageSpan {

    public static final int EMOJI_SIZE = 20;
    private String url;
    private Context mContext;
    private TextView mTextView;

    public UrlImageSpan(Context context, String url, Bitmap bitmap, TextView textView) {
        super(context, bitmap);
        mContext = context;
        mTextView = textView;
        this.url = url;
    }

    /**
     * 按宽度缩放图片
     *
     * @param bmp  需要缩放的图片源
     * @param newW 需要缩放成的图片宽度
     * @return 缩放后的图片
     */
    public static Bitmap zoom(@NonNull Bitmap bmp, int newW) {

        // 获得图片的宽高
        int width = bmp.getWidth();
        int height = bmp.getHeight();

        // 计算缩放比例
        float scale = ((float) newW) / width;

        // 取得想要缩放的matrix参数
        Matrix matrix = new Matrix();
        matrix.postScale(scale, scale);

        // 得到新的图片
        Bitmap newbm = Bitmap.createBitmap(bmp, 0, 0, width, height, matrix, true);

        return newbm;
    }

    @Override
    public Drawable getDrawable() {
        Glide.with(mContext)
                .asBitmap()
                .load(url).into(new SimpleTarget<Bitmap>() {
            @Override
            public void onResourceReady(@NonNull Bitmap resource, @Nullable Transition<? super Bitmap> transition) {
                setNetBitmap(resource);
            }
        });

        return super.getDrawable();
    }

    private void setNetBitmap(Bitmap resource) {
        Resources res = mContext.getResources();
        int targetWidth = DisplayUtil.dp2px(mContext, EMOJI_SIZE);
        Bitmap zoom = zoom(resource, targetWidth);
        BitmapDrawable b = new BitmapDrawable(res, zoom);

        b.setBounds(0, 0, b.getIntrinsicWidth(), b.getIntrinsicHeight());
        Field mDrawable;
        Field mDrawableRef;
        try {
            mDrawable = ImageSpan.class.getDeclaredField("mDrawable");
            mDrawable.setAccessible(true);
            mDrawable.set(UrlImageSpan.this, b);

            mDrawableRef = DynamicDrawableSpan.class.getDeclaredField("mDrawableRef");
            mDrawableRef.setAccessible(true);
            mDrawableRef.set(UrlImageSpan.this, null);

            if (mTextView != null) {
                mTextView.setText(mTextView.getText());
            }
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        } catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
    }
}

