package com.byh.module.onlineoutser.im.utils;

import android.widget.ImageView;

import com.blankj.utilcode.util.Utils;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.RequestOptions;
import com.kangxin.common.Pretty;
import com.kangxin.common.imageloader.Style;

public class ImgUtil {

    public static void load(String url, ImageView target) {
        Pretty.create()
                .loadImage(url)
                .into(target);
    }

    public static void loadCircle(String url, int defResId, ImageView target) {
        Pretty.create()
                .loadImage(url)
                .bitmapTransform(Style.CIRCLE)
                .placeholder(defResId)
                .err(defResId)
                .into(target);
    }

    public static void loadCircle(int defResId, ImageView target) {
        RequestOptions mRequestOptions = RequestOptions.circleCropTransform()
                .diskCacheStrategy(DiskCacheStrategy.NONE)//不做磁盘缓存
                .skipMemoryCache(true);//不做内存缓存
        Glide.with(Utils.getApp()).load(defResId).apply(mRequestOptions).into(target);
    }


}
