package com.ebaiyihui.doctor.ca.views;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.Gravity;
import android.view.View;
import android.widget.TextView;

import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;

import com.kangxin.common.R;


public class CenterHintDialogSpe extends Dialog {

    String titleText;
    String messageText;
    String rightText;
    String leftText;
    int color =-1;
    View.OnClickListener leftClick;
    View.OnClickListener rightClick;
    boolean isShow = true;
    boolean isTouchOutCancel;

    public CenterHintDialogSpe(@NonNull Context context) {
        super(context);
    }

    public CenterHintDialogSpe setTitle(String title) {
        this.titleText = title;
        return this;

    }

    public CenterHintDialogSpe setTitleColor(@ColorInt int color) {
        this.color = color;
        return this;

    }

    public CenterHintDialogSpe setMessage(String message) {
        this.messageText = message;
        return this;
    }

    public CenterHintDialogSpe setRightText(String rightText) {
        this.rightText = rightText;
        return this;

    }

    public CenterHintDialogSpe setLeftText(String leftText) {
        this.leftText = leftText;
        return this;
    }

    public CenterHintDialogSpe bindLeftClick(View.OnClickListener leftClick) {
        this.leftClick = leftClick;
        return this;
    }

    public CenterHintDialogSpe bindRightClick(View.OnClickListener rightClick) {
        this.rightClick = rightClick;
        return this;
    }

    public CenterHintDialogSpe setShowCancel(boolean isShow) {
        this.isShow = isShow;
        return this;
    }

    public CenterHintDialogSpe setTouchOutCancel(boolean isCancel) {
        this.isTouchOutCancel = isCancel;
        return this;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        setContentView(R.layout.centerhint_dialog_layout_ca);

        if (getWindow() != null) {
            getWindow().setGravity(Gravity.CENTER);
            getWindow().setLayout(-1, -2);
            getWindow().setBackgroundDrawable(null);
        }

        setCanceledOnTouchOutside(isTouchOutCancel);

        TextView title = findViewById(R.id.title);
        TextView message = findViewById(R.id.message);

        title.setText(titleText);
        if(color !=-1){
            title.setTextColor(color);
        }
        message.setText(messageText);

        TextView cancel = findViewById(R.id.cancel);
        TextView ok = findViewById(R.id.ok);

        if (!TextUtils.isEmpty(rightText))
            ok.setText(rightText);

        if (!TextUtils.isEmpty(leftText))
            cancel.setText(leftText);

        View v = findViewById(R.id.divider);

        if (!isShow) {
            cancel.setVisibility(View.GONE);
            v.setVisibility(View.GONE);
        }

        if (leftClick != null)
            cancel.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    dismiss();
                    leftClick.onClick(v);
                }
            });

        else cancel.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                dismiss();
            }
        });

        if (rightClick != null)
            ok.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    dismiss();
                    rightClick.onClick(v);
                }
            });
        else ok.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                dismiss();
            }
        });

    }

}
