package com.ebaiyihui.module_bothreferral.decorate;

import android.annotation.SuppressLint;
import android.app.Dialog;
import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.util.DisplayMetrics;
import android.view.Gravity;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;

import com.kangxin.common.R;

import java.util.List;

public class WheelDialog extends Dialog {

    private WheelListView wheelListView;

    private TextView tv_cancel;
    private TextView tv_success;
    private TextView tv_title;
    private String title = "";
    private OnWheelSelectListener listener;

    @SuppressLint("PrivateResource")
    public WheelDialog(@NonNull Context context) {
        super(context, R.style.Base_Theme_AppCompat_Dialog);
        initView(context);
        initListener();
    }

    @SuppressLint("PrivateResource")
    public WheelDialog(@NonNull Context context, String title) {
        super(context, R.style.Base_Theme_AppCompat_Dialog);
        this.title = title;
        initView(context);
        initListener();
    }

    private void initView(Context context) {
        View rootView = View.inflate(getContext(), R.layout.data_select_wheel, null);
        wheelListView = rootView.findViewById(R.id.wl);
        tv_cancel = rootView.findViewById(R.id.tv_cancel);
        tv_success = rootView.findViewById(R.id.tv_success);
        tv_title = rootView.findViewById(R.id.tv_title);
        tv_title.setText(title);
        setContentView(rootView);
        Window window = getWindow();
        FrameLayout centerArea = rootView.findViewById(R.id.centerArea);
        wheelListView.post(new Runnable() {
            @Override
            public void run() {

                int height = wheelListView.getChildAt(0).getMeasuredHeight();
                FrameLayout.LayoutParams params = (FrameLayout.LayoutParams) centerArea.getLayoutParams();
                params.height = height;

                centerArea.setLayoutParams(params);
            }
        });

        if (window != null) {
            window.setBackgroundDrawable(new ColorDrawable(Color.argb(0, 0, 0, 0)));
            WindowManager.LayoutParams params = window.getAttributes();
            params.gravity = Gravity.BOTTOM | Gravity.CENTER_HORIZONTAL;
            //设置dialog宽度充满屏幕
            WindowManager manager = (WindowManager) context.getSystemService(Context.WINDOW_SERVICE);
            window.getDecorView().setPadding(0, 0, 0, 0);
            DisplayMetrics dm = new DisplayMetrics();
            manager.getDefaultDisplay().getMetrics(dm);
            WindowManager.LayoutParams lp = window.getAttributes();
            lp.width = WindowManager.LayoutParams.MATCH_PARENT;
            lp.height = WindowManager.LayoutParams.WRAP_CONTENT;
            window.setAttributes(lp);
        }
    }

    private void initListener() {
        tv_cancel.setOnClickListener(v -> dismiss());
        tv_success.setOnClickListener(v -> {
            String selectLabel = wheelListView.getSelectLabel();
            if (listener != null) {
                listener.onClickOk(wheelListView.getSelectIndex(), selectLabel);
            }
        });
    }

    public void setLabels(List<String> labels) {
        wheelListView.setLabels(labels);
    }

    public void setOnWheelSelectListener(OnWheelSelectListener listener) {
        this.listener = listener;
    }

    public interface OnWheelSelectListener {
        void onClickOk(int index, String selectLabel);
    }

}
