package com.floatwindow;

import android.content.Context;
import android.graphics.Point;
import android.graphics.Rect;
import android.view.LayoutInflater;
import android.view.View;
import android.view.WindowManager;

/**
 * Created by yhao on 2017/12/22.
 * https://github.com/yhaolpz
 */

class Util {


  private static Point sPoint;

  static View inflate(Context applicationContext, int layoutId) {
    LayoutInflater inflate = (LayoutInflater) applicationContext.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
    return inflate.inflate(layoutId, null);
  }

  static int getScreenWidth(Context context) {
    if (sPoint == null) {
      sPoint = new Point();
      WindowManager wm = (WindowManager) context.getSystemService(Context.WINDOW_SERVICE);
      wm.getDefaultDisplay().getSize(sPoint);
    }
    return sPoint.x;
  }

  static int getScreenHeight(Context context) {
    if (sPoint == null) {
      sPoint = new Point();
      WindowManager wm = (WindowManager) context.getSystemService(Context.WINDOW_SERVICE);
      wm.getDefaultDisplay().getSize(sPoint);
    }
    return sPoint.y;
  }

  static boolean isViewVisible(View view) {
    return view.getGlobalVisibleRect(new Rect());
  }
}
