package com.kangxin.common.base.safe;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.ComponentName;
import android.content.Context;
import android.os.Build;
import android.util.Log;
import android.view.View;

import com.kangxin.doctor.worktable.dialog.CenterHintDialogSpe;

import java.util.List;

/**
 * @author dongweizhou
 * @time 11/30/21
 * @describe 防止页面拦截
 **/
public class ViewLjUtil {


  public static String lj (Context context){


    String topActivity = null;

   ActivityManager activityManager =  (ActivityManager) context.getSystemService(Context.ACTIVITY_SERVICE);


    if (Build.VERSION.SDK_INT>20) {
      List<ActivityManager.RunningAppProcessInfo> tasks = activityManager.getRunningAppProcesses();

      if (null != tasks && tasks.size() > 0) {
        topActivity = tasks.get(0).processName;
      }
    }else{
      List<ActivityManager.RunningTaskInfo> runningTasks = activityManager.getRunningTasks(1);
      ComponentName topActivity1 = runningTasks.get(0).topActivity;
      topActivity =  topActivity1.getPackageName();
    }

    Log.d("ViewLjUtil","================"+topActivity);
    return topActivity;
  }


  /**
   * 页面被劫持
   * @param context
   */
  public static void viewKidnap(Activity context,String appId){
//    String appId = "";
//    if (ByPlatform.hasYc()) {
//      appId = "com.ycsrmyy.doctor";
//    }else if(ByPlatform.hasNde()){
//      appId = "com.byh.doctor.ncschhosp";
//    }else if(ByPlatform.hasLyt()){
//      appId  = "com.lyszxyy.doctor";
//    }else if(ByPlatform.hasHt()){
//      appId  = "com.space.flight.doctor";
//    }else {
//      appId  = "com.kangxin.doctor";
//    }

    if (!lj(context).equals(appId)) {
      // 页面被劫持
      CenterHintDialogSpe centerHintDialogSpe = new CenterHintDialogSpe(context)
        .setMessage("无法使用")
        .setTitle("监测到页面被劫持")
        .setRightText("退出")
        .setShowCancel(false)
        .setTouchOutCancel(false)
        .bindRightClick(new View.OnClickListener() {
          @Override
          public void onClick(View v) {
            context.finish();
          }
        });
      centerHintDialogSpe.setCanceledOnTouchOutside(false);

      centerHintDialogSpe.show();
    }

  }



}
