package com.kangxin.common.byh.widget;

import android.content.Context;
import android.content.Intent;
import android.provider.Settings;
import android.util.Log;
import android.util.Pair;
import android.view.View;
import android.view.ViewGroup;

import androidx.recyclerview.widget.RecyclerView;

import com.blankj.utilcode.util.NetworkUtils;
import com.blankj.utilcode.util.Utils;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.kangxin.common.R;
import com.kangxin.common.widget.RecyclerViewCache;

import java.util.ArrayList;
import java.util.List;

public class DefEmptyPageProxy {

  private static final String TAG = "DefEmptyPageProxy";
  private static DefEmptyPageProxy INSTANCE ;
  private Context mContext;
  private DefaultEmptyPage mDefEmptyPage;
  private DefaultEmptyPage.OnDefpageClickListener onDefpageClickListener;

  private List<DefEmptyType> defEmptyTypes = new ArrayList<>();
  private List<DefaultEmptyPage.OnDefpageClickListener> onDefpageClickListenerList = new ArrayList<>();

  public enum DefEmptyType{
    NO_RECORDS, //无记录
    NO_PAGE, //无页面
    NO_SEARCH_RESULT,//无搜索结果
    NET_EXCEPTION, //网络异常
    NO_GROUP_CHATS, //没有群聊
    NO_HEALTH_MANAGERS, //无健康管理计划
    NO_AUTH, //权限未开通
  }

  private DefEmptyPageProxy(Context context) {
    mContext = context;
  }

  public static DefEmptyPageProxy getInstance(Context context){
    if(INSTANCE == null){
      INSTANCE = new DefEmptyPageProxy(context);
    }
    return INSTANCE;
  }


  public void putClickListener(DefaultEmptyPage.OnDefpageClickListener defpageClickListener){
    if(defpageClickListener != null){
      onDefpageClickListenerList.add(defpageClickListener);
    }
  }

  public void removeClickListener(DefaultEmptyPage.OnDefpageClickListener defpageClickListener){
    if(defpageClickListener != null){
      onDefpageClickListenerList.remove(defpageClickListener);
    }
  }

  public DefaultEmptyPage.OnDefpageClickListener getDefEmptyListener(){
    if(onDefpageClickListenerList.size() > 0){
      return onDefpageClickListenerList.get(onDefpageClickListenerList.size() - 1);
    }

    return null;
  }

  public void putDefEmptyType(DefEmptyType defEmptyType){
    if(defEmptyType != null){
      defEmptyTypes.add(defEmptyType);
    }
  }

  public void removeDefEmptyType(DefEmptyType defEmptyType){
    if(defEmptyType != null){
      defEmptyTypes.remove(defEmptyType);
    }
  }

  public DefEmptyType getDefEmptyType(){
    if(defEmptyTypes.size() > 0){
      return defEmptyTypes.get(defEmptyTypes.size() - 1);
    }

    return null;
  }


  public void loadDefEmptyPage(){
    ViewGroup viewGroup = RecyclerViewCache.getInstance().getRecyclerView();
    if(viewGroup instanceof RecyclerView){
      RecyclerView recyclerView = (RecyclerView) viewGroup;
      RecyclerView.Adapter adapter = recyclerView.getAdapter();
      if(adapter instanceof BaseQuickAdapter){
        List<Object> dataList =  ((BaseQuickAdapter) adapter).getData();
        Log.i(TAG, "loadDefEmptyPage: dataList:" + dataList);
        DefEmptyPageProxy.DefEmptyType defEmptyType = getDefEmptyType();
        setOnDefpageClickListener(getDefEmptyListener());

        if(defEmptyType != null){
         createDefEmptyPage(dataList, viewGroup, defEmptyType);
        }else {
          createDefEmptyPage(dataList, viewGroup, DefEmptyType.NO_RECORDS);
        }
      }else {
        //如果不是BaseQuickAdapter的情况
        Log.i(TAG, "loadDefEmptyPage: 不是BaseQuickAdapter");
      }
    }else {
      //如果不是RecyclerView的情况
      Log.i(TAG, "loadDefEmptyPage: 不是RecyclerView的情况");
    }
  }

  public <T> void createDefEmptyPage(ViewGroup busGroupView, DefEmptyType defEmptyType){
    createDefEmptyPage(null, busGroupView, defEmptyType);
  }

  public <T> void createDefEmptyPage(List<T> dataList, ViewGroup busGroupView, DefEmptyType defEmptyType){
    boolean isShowBtn = true;
    if(onDefpageClickListener == null && onDefpageClickListenerList.isEmpty()){
      isShowBtn = false;
    }

    switch (defEmptyType){
      case NO_RECORDS:
        mDefEmptyPage = new DefaultEmptyPage.Builder<T>(mContext)
          .setBusViewGroup(busGroupView)
          .setDataList(dataList)
          .setOnDefpageClickListener(onDefpageClickListener)
          .showBtn(isShowBtn)
          .create();
        break;
      case NO_PAGE:
        mDefEmptyPage = new DefaultEmptyPage.Builder<T>(mContext)
          .setBusViewGroup(busGroupView)
          .setDataList(dataList)
          .setOnDefpageClickListener(onDefpageClickListener)
          .setDefImgid(R.drawable.ic_defnopage_img)
          .setDefDescText(getString(R.string.commbyh_zanwuyem))
          .setDefEngText(getString(R.string.commbyh_zanwuyem_eng))
          .setDefBtnText(getString(R.string.commbyh_wozhidle))
                .showBtn(isShowBtn)
          .create();
        break;
      case NO_SEARCH_RESULT:
        mDefEmptyPage = new DefaultEmptyPage.Builder<T>(mContext)
          .setBusViewGroup(busGroupView)
          .setDataList(dataList)
          .setOnDefpageClickListener(onDefpageClickListener)
          .setDefImgid(R.drawable.ic_defnosearch_img)
          .setDefDescText(getString(R.string.commbyh_nosearch_result))
          .setDefEngText(getString(R.string.commbyh_nosearch_result_eng))
          .setDefBtnText(getString(R.string.commbyh_wozhidle))
                .showBtn(isShowBtn)
          .create();
        break;
      case NET_EXCEPTION:
        mDefEmptyPage = new DefaultEmptyPage.Builder<T>(mContext)
          .setBusViewGroup(busGroupView)
          .setDataList(dataList)
          .setOnDefpageClickListener(onDefpageClickListener)
          .setDefImgid(R.drawable.ic_defnet_exception)
          .setDefDescText(getString(R.string.comm_net_exception))
          .setDefEngText(getString(R.string.comm_net_exception_eng))
          .setDefBtnText(getString(R.string.comm_check_net))
                .showBtn(isShowBtn)
          .create();
        break;
      case NO_GROUP_CHATS:
        mDefEmptyPage = new DefaultEmptyPage.Builder<T>(mContext)
                .setBusViewGroup(busGroupView)
                .setDataList(dataList)
                .setOnDefpageClickListener(onDefpageClickListener)
                .setDefImgid(R.drawable.ic_defno_groupchat)
                .setDefDescText(getString(R.string.byhim_commbyh_def_nochatgroupdesc))
                .setDefEngText(getString(R.string.byhim_commbyh_def_nochatgroupdesc_eng))
                .setDefBtnText(getString(R.string.byhim_start_groupchat))
                .showBtn(isShowBtn)
                .create();
        break;
      case NO_HEALTH_MANAGERS:
        mDefEmptyPage = new DefaultEmptyPage.Builder<T>(mContext)
                .setBusViewGroup(busGroupView)
                .setDataList(dataList)
                .setOnDefpageClickListener(onDefpageClickListener)
                .setDefImgid(R.drawable.ic_defno_health_manager)
                .setDefDescText(getString(R.string.comm_no_health_manager))
                .setDefEngText(getString(R.string.comm_no_health_manager_eng))
                .setDefBtnText(getString(R.string.comm_make_healthmanager_plan))
                .showBtn(isShowBtn)
                .create();
        break;
      case NO_AUTH:
        mDefEmptyPage = new DefaultEmptyPage.Builder<T>(mContext)
                .setBusViewGroup(busGroupView)
                .setDataList(dataList)
                .setOnDefpageClickListener(onDefpageClickListener)
                .setDefImgid(R.drawable.ic_defpage_no_auth)
                .setDefDescText(getString(R.string.comm_no_auth))
                .setDefEngText(getString(R.string.comm_no_auth_eng))
                .setDefBtnText(getString(R.string.comm_open_auth))
                .showBtn(isShowBtn)
                .create();
        break;
    }
  }

  public void showNetErrPage(){
    ViewGroup viewGroup = RecyclerViewCache.getInstance().getRecyclerView();
    if(viewGroup != null){
      setOnDefpageClickListener(new DefaultEmptyPage.OnDefpageClickListener() {
        @Override
        public void onClickDefbtn(View view) {
          Intent intent = new Intent(Settings.ACTION_WIFI_SETTINGS);
          intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
          mContext.startActivity(intent);
        }
      });
     createDefEmptyPage(viewGroup,
              DefEmptyPageProxy.DefEmptyType.NET_EXCEPTION);
    }
  }

  public void showDefPage(boolean isShow){
    if(mDefEmptyPage != null){
      mDefEmptyPage.showDef(isShow);
    }
  }

  public void setOnDefpageClickListener(DefaultEmptyPage.OnDefpageClickListener onDefpageClickListener) {
    this.onDefpageClickListener = onDefpageClickListener;
  }


  private String getString(int id){
    return mContext.getString(id);
  }
}
