package com.kangxin.common.byh.widget;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.DrawableRes;

import com.kangxin.common.R;
import com.scwang.smartrefresh.layout.SmartRefreshLayout;

import java.util.List;

public class DefaultEmptyPage {

  private ViewGroup mBusViewGroup;
  private View mDefView;

  public void showDef(boolean isShow){

    if(isShow){
      mDefView.setVisibility(View.VISIBLE);
      mBusViewGroup.setVisibility(View.GONE);
    }else {
      mDefView.setVisibility(View.GONE);
      mBusViewGroup.setVisibility(View.VISIBLE);
    }
  }


  public interface OnDefpageClickListener{
    void onClickDefbtn(View view);
  }

  public static class Builder<T>{

    private ViewGroup mBusViewGroup;
    @DrawableRes
    private int mImgId;
    private String mBtnText;
    private String mDefDescText;
    private String mDefDescEnglishText;

    private Context mContext;
    private OnDefpageClickListener onDefpageClickListener;
    private List<T>  mDataList;
    private boolean isShowBtn;

    public Builder(Context context) {
      this.mContext = context;
    }


    public Builder showBtn(boolean isShowBtn){
      this.isShowBtn = isShowBtn;
      return this;
    }

    public Builder setDefDescText(String text){
      mDefDescText = text;
      return this;
    }

    public Builder setDefEngText(String engText){
      mDefDescEnglishText = engText;
      return this;
    }

    public Builder setDataList(List<T> dataList){
      mDataList = dataList;
      return this;
    }

    public Builder setBusViewGroup(ViewGroup viewGroup){
      mBusViewGroup = viewGroup;
      return this;
    }

    public Builder setDefImgid(@DrawableRes int imgId){
      mImgId = imgId;
      return this;
    }

    public Builder setDefBtnText(String btnText){
      mBtnText = btnText;
      return this;
    }


    public Builder setOnDefpageClickListener(OnDefpageClickListener onDefpageClickListener){
      this.onDefpageClickListener = onDefpageClickListener;
      return this;
    }


    public DefaultEmptyPage create(){
      DefaultEmptyPage defaultEmptyPage = new DefaultEmptyPage();
      defaultEmptyPage.mBusViewGroup = this.mBusViewGroup;
      View defView;
      ViewParent parent = this.mBusViewGroup.getParent();
      ViewGroup parentGroupView = null;
      if(parent instanceof ViewGroup){
        parentGroupView = (ViewGroup) parent;
      }

      if(getDefView(parentGroupView) == null){
        defView = View.inflate(mContext, R.layout.commbyh_list_empty_place2, null);
      }else {
        defView = getDefView(parentGroupView);
      }

      defaultEmptyPage.mDefView = defView;

      //////////////init views of defview//////////

      ImageView placeImgView = defView.findViewById(R.id.place_img);

      if(mImgId != 0){
        placeImgView.setImageResource(mImgId);
      }

      TextView defDescView = defView.findViewById(R.id.place_seat_desc);
      if(!TextUtils.isEmpty(mDefDescText)){
        defDescView.setText(mDefDescText);
      }
      TextView defDescView2 = defView.findViewById(R.id.place_seat_desc2);
      if(!TextUtils.isEmpty(mDefDescEnglishText)){
        defDescView2.setText(mDefDescEnglishText);
      }

      TextView defBtn = defView.findViewById(R.id.def_page_btn);
      if(isShowBtn){
        defBtn.setVisibility(View.VISIBLE);
      }else {
        defBtn.setVisibility(View.GONE);
      }
      if(!TextUtils.isEmpty(mBtnText)){
        defBtn.setText(mBtnText);
      }
      defBtn.setOnClickListener(new View.OnClickListener() {
        @Override
        public void onClick(View v) {
          //click defview btn
          if(onDefpageClickListener != null){
            onDefpageClickListener.onClickDefbtn(v);
          }
        }
      });

      ////////////////////////////////////


      if(mDataList != null && mDataList.size() > 0){
        mBusViewGroup.setVisibility(View.VISIBLE);
        defView.setVisibility(View.GONE);
      }else {
        mBusViewGroup.setVisibility(View.GONE);
        defView.setVisibility(View.VISIBLE);
      }

      if(parentGroupView != null && !hasDefView(parentGroupView)){
        if(parentGroupView instanceof SmartRefreshLayout){
          throw new RuntimeException("SmartRefreshLayout must have only a child view, please add a only view!!!");
        }

        defView.setTag(ADD_DEF_VIEW_TAG);
        parentGroupView.addView(defView);
      }

      return defaultEmptyPage;
    }

    private static final String ADD_DEF_VIEW_TAG = "add_def_view";

    public ViewGroup getDefView(ViewGroup viewGroup){
      int childCount = viewGroup.getChildCount();
      for (int i = 0; i < childCount; i++) {
        View childView = viewGroup.getChildAt(i);
        if(childView.getTag() != null && childView.getTag() instanceof String){
          String viewTag = (String) childView.getTag();
          if(ADD_DEF_VIEW_TAG.equals(viewTag)){
            return (ViewGroup) childView;
          }
        }
      }

      return null;
    }
    private boolean hasDefView(ViewGroup viewGroup){
      int childCount = viewGroup.getChildCount();
      for (int i = 0; i < childCount; i++) {
        View childView = viewGroup.getChildAt(i);

        if(childView.getTag() != null && childView.getTag() instanceof String){
          String viewTag = (String) childView.getTag();
          if(ADD_DEF_VIEW_TAG.equals(viewTag)){
              return true;
          }
        }
      }

      return false;
    }

  }

}
