package com.kangxin.common.framework;

import android.app.Activity;

import androidx.fragment.app.Fragment;

public class PicSelectorHelper {

    private static PicSelectorHelper INSTANCE = new PicSelectorHelper();
    private ImageSelector mImageSelector;

    private PicSelectorHelper() {
        mImageSelector = new PictureSelectorImpl();
    }

    public static PicSelectorHelper getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PicSelectorHelper();
        }

        return INSTANCE;
    }

    public PicSelectorHelper init(Fragment fragment) {
        mImageSelector.init(fragment);
        return this;
    }

    public PicSelectorHelper init(Activity activity) {
        mImageSelector.init(activity);
        return this;
    }


    /**
     * 打开相册,选取一张
     */
    @Deprecated
    public void openCameraSingle(ImageSelector.OnImageSelectedListener listener) {
        mImageSelector.openCameraSingle(listener);
    }


    public void openCamera(Activity activity, ImageSelector.OnImageSelectedListener listener) {
        mImageSelector.openCamera(activity, listener);
    }

    public void openCamera(Fragment fragment, ImageSelector.OnImageSelectedListener listener) {
        mImageSelector.openCamera(fragment, listener);
    }

    /***
     * 打开相机，选取单张
     */
    public void openAlbumSingle(ImageSelector.OnImageSelectedListener listener) {
        mImageSelector.openAlbumSingle(listener);
    }


    /***
     * 打开相机，选取多张
     */
    public void openAlbumMany(ImageSelector.OnImagesSelectedListener listener) {
        mImageSelector.openAlbumMany(listener);
    }


}
