package com.kangxin.common.framework;

import android.content.Context;

public class Selector {

    private static Selector instance;
    private static Context mContext;
    private ImageSelector selector = new GalleryFinalSelector();

    /**
     * 单例
     */
    private Selector() {
    }


    public static Selector getInstance() {
        if (instance == null) {
            instance = new Selector();
        }
        return instance;
    }

    public static void init(Context context) {
        mContext = context;
        getInstance().selector.init(mContext);
    }

    /**
     * 打开相册,选取一张
     */
    public void openCameraSingle(ImageSelector.OnImageSelectedListener listener) {
        selector.openCameraSingle(listener);
    }


    /***
     * 打开相机，选取单张
     */
    public void openAlbumSingle(ImageSelector.OnImageSelectedListener listener) {
        selector.openAlbumSingle(listener);
    }

    /***
     * 打开相机，选取单张
     */
    public void openAlbumMany(ImageSelector.OnImagesSelectedListener listener) {
        selector.openAlbumMany(listener);
    }

}
