package com.kangxin.common.http.interceptor;


import com.kangxin.common.http.entity.DownResponseBody;
import com.kangxin.common.http.listener.DownListener;

import java.io.IOException;

import okhttp3.Interceptor;
import okhttp3.Response;

public class DownloadInterceptor implements Interceptor {


    private DownListener downListener;

    public DownloadInterceptor(DownListener downListener) {
        this.downListener = downListener;
    }

    /**
     * 对相应体偷梁换柱
     *
     * @param chain
     * @return
     * @throws IOException
     */
    @Override
    public Response intercept(Chain chain) throws IOException {

        Response response = chain.proceed(chain.request());

        return response.newBuilder().body(new DownResponseBody(response.body(), downListener)).build();

    }
}
