package com.kangxin.common.rx;

import com.kangxin.common.base.mvp.IBaseProgressView;
import com.kangxin.common.widget.RxBaseObserver;

public abstract class ProgressObserver<T> extends RxBaseObserver<T> {

    private IBaseProgressView mBaseView;

    public ProgressObserver(IBaseProgressView baseView) {
        mBaseView = baseView;
    }


    @Override
    protected void onStart() {
        super.onStart();
        mBaseView.startReq();
    }

    @Override
    public void onReqErr(int code, String msg, String errCode) {
        super.onReqErr(code, msg, errCode);
        mBaseView.endReq();
    }

    @Override
    public void onReqErr(Throwable e) {
        super.onReqErr(e);
        mBaseView.endReq();
    }


    @Override
    public void onComplete() {
        super.onComplete();
        mBaseView.endReq();
    }
}
