package com.kangxin.common.rx;

import android.accounts.NetworkErrorException;
import android.view.ViewGroup;

import com.blankj.utilcode.util.ToastUtils;
import com.blankj.utilcode.util.Utils;
import com.google.gson.JsonParseException;
import com.kangxin.common.R;
import com.kangxin.common.byh.widget.DefEmptyPageProxy;
import com.kangxin.common.util.StringsUtils;
import com.kangxin.common.widget.RecyclerViewCache;

import java.net.UnknownHostException;

import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import retrofit2.HttpException;

public abstract class SampleObserver<M> implements Observer<M> {


    private static final String TAG = "SampleObserver";

    @Override
    public void onSubscribe(Disposable d) {

    }

    @Override
    public abstract void onNext(M t);

    @Override
    public void onError(Throwable e) {
        e.printStackTrace();

        if (e instanceof UnknownHostException) {
            ToastUtils.showShort(StringsUtils.getString(R.string.common_qingjianchawangluolianjieshifoukeyong));
            DefEmptyPageProxy.getInstance(Utils.getApp()).showNetErrPage();
            return;
        } else if (e instanceof NetworkErrorException || e instanceof HttpException) {
            ToastUtils.showShort(StringsUtils.getString(R.string.common_wangluofangwencuowu));
            return;
        } else if (e instanceof JsonParseException) {
            return;
        } else if (e instanceof NullPointerException) {
            ToastUtils.showShort(e + "");
            return;
        } else if (e instanceof ArrayIndexOutOfBoundsException) {
            ToastUtils.showShort(e + "");
            return;
        }
    }

    @Override
    public void onComplete() {
        DefEmptyPageProxy.getInstance(Utils.getApp()).loadDefEmptyPage();
    }
}
