package com.kangxin.common.util;

import com.kangxin.common.R;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

/**
 * Created by superstar on 16/12/7.
 */
public class
TimeUtil {
    static SimpleDateFormat dateFormat1 = new SimpleDateFormat("HH:mm");
    static SimpleDateFormat dateFormat2 = new SimpleDateFormat("yyyy MM-dd HH:mm");
    static SimpleDateFormat dateFormat3 = new SimpleDateFormat("yyyy MM-dd");
    static SimpleDateFormat dateFormat4 = new SimpleDateFormat("MM-dd");
    static SimpleDateFormat dateFormat5 = new SimpleDateFormat("yyyy");

    public static String formatYearMontnDay(long millisecond) {
        if (millisecond == 0) {
            return "";
        } else {
            return dateFormat3.format(millisecond);
        }
    }

    public static String formatTime(Long millisecond) {
        if (millisecond == null || millisecond == 0) {
            return "";
        } else {
            return dateFormat2.format(millisecond);

        }
    }

    /**
     * 将时间戳转换成日期
     *
     * @param millisecond
     * @return
     */
    public static String timestamp2Str(long millisecond) {
        String strTime = "";
        Calendar c = Calendar.getInstance();
        int year = c.get(Calendar.YEAR);
        int month = c.get(Calendar.MONTH) + 1;
        int day = c.get(Calendar.DAY_OF_MONTH);

        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String[] mdataTime = dateFormat.format(millisecond).split("-");
//        LogUtils.d(year+"---"+month+"----"+day+"=========="+mdataTime[0]+"==="+mdataTime[1]+"---"+mdataTime[2]);
        /**判断年份  时间超前*/
        if (year > Integer.parseInt(mdataTime[0])) {
            strTime = dateFormat2.format(millisecond);
        } else if (year == Integer.parseInt(mdataTime[0])) {
            /**判断月份  时间超前*/
            if (month > Integer.parseInt(mdataTime[1])) {
                strTime = dateFormat2.format(millisecond);
            } else if (month == Integer.parseInt(mdataTime[1])) {
                /**判断日  时间超前*/
                if (day > Integer.parseInt(mdataTime[2])) {
                    strTime = dateFormat2.format(millisecond);
                } else if (day == Integer.parseInt(mdataTime[2])) {
                    strTime = StringsUtils.getString(R.string.common_jintian_) + dateFormat1.format(millisecond);
                } else if ((day - 1) == Integer.parseInt(mdataTime[2])) {
                    strTime = StringsUtils.getString(R.string.common_zuotian_) + dateFormat1.format(millisecond);
                } else {
                    strTime = dateFormat2.format(millisecond);
                }
            } else {
                strTime = dateFormat2.format(millisecond);
            }
        } else if (year < Integer.parseInt(mdataTime[0])) {
            /**去年或前年*/
            strTime = dateFormat2.format(millisecond);
        }
        return strTime;
    }

    /**
     * 将时间戳转换成日期
     *
     * @param millisecond
     * @return
     */
    public static String timestamp2StrWithWeek(long millisecond) {
        if (millisecond == 0) {
            return "";
        }

        SimpleDateFormat sdf = new SimpleDateFormat("MM-dd hh:mm");
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(millisecond);

        String week = getWeek(calendar);
        return sdf.format(calendar.getTime() + " " + week);
    }

    /**
     * 将时间戳转换成日期
     *
     * @param overtime
     * @return
     */
    public static String getFormatOverTime(long overtime) {
        if (overtime == 0) {
            return "";
        }

        String result = "";

        long currentTime = System.currentTimeMillis();
        long totalMinutes = (overtime - currentTime) / 1000 / 60; // 分钟

        return result;
    }

    public static String getWeek(Calendar calendar) {
        String Week = StringsUtils.getString(R.string.common_zhou);
        switch (calendar.get(Calendar.DAY_OF_WEEK)) {
            case 1:
                Week += StringsUtils.getString(R.string.common_ri);
                break;
            case 2:
                Week += StringsUtils.getString(R.string.common_yi);
                break;
            case 3:
                Week += StringsUtils.getString(R.string.common_er);
                break;
            case 4:
                Week += StringsUtils.getString(R.string.common_san);
                break;
            case 5:
                Week += StringsUtils.getString(R.string.common_si);
                break;
            case 6:
                Week += StringsUtils.getString(R.string.common_wu);
                break;
            case 7:
                Week += StringsUtils.getString(R.string.common_liu);
                break;
            default:
                break;
        }
        return Week;
    }

    /**
     * 将日期转换成时间戳
     *
     * @param date    日期  03-22 15:12
     * @param pattern 格式  MM-dd hh:mm
     * @return
     */
    public static String date2Timestamp(String date, String pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        try {
            return String.valueOf(sdf.parse(date).getTime());
        } catch (ParseException e) {
            return "";
        }
    }

    public static String timeFormat(String time, String pattern) {

        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
        Date date = new Date();
        date.setTime(Long.parseLong(time));
        return simpleDateFormat.format(date);
    }

    /**
     * 将时间转成毫秒值
     *
     * @return
     */
    public static long stringTimeToLong(String time) {
        try {
            return dateFormat2.parse(time).getTime();
        } catch (ParseException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static String getMonthAndDay(long millisecond) {
        return dateFormat4.format(millisecond);
    }

    public static String getYear(long millisecond) {
        return dateFormat5.format(millisecond);
    }

    public static String leftTime(long time) {
        long overtime = time / 1000;
        if (overtime > 0) {
            long m = overtime / 60;
            long s = overtime - m * 60;
            return String.format(StringsUtils.getString(R.string.common_shengyushijian__1_02d__2_02d), m, s);
        } else {
            return "";
        }
    }

    public static String leftTimeTwo(long overtime) {

        if (overtime > 0) {
            long h = overtime / 1000 / 60 / 60;
            long m = (overtime - h * 60 * 60 * 1000) / 1000 / 60;
            if (h > 0) { //超过一小时,显示时分秒
                return h + StringsUtils.getString(R.string.common_xiaoshi) + m + StringsUtils.getString(R.string.common_fen);
            } else if (m > 0) { //超过一分钟 ,显示分秒
                return m + StringsUtils.getString(R.string.common_fen);
            } else {
                return "0";
            }
        } else {
            return "0";
        }
    }

    //将时间戳转换成日期
    public static String stampToDate(long s, String format) {
        String res;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format);
        Date date = new Date(s);
        res = simpleDateFormat.format(date);
        return res;
    }

    public static long dateToLong(String date, String format, long defaultValue) {
        try {
            return new SimpleDateFormat(format).parse(date).getTime();
        } catch (Exception e) {
            e.printStackTrace();
            return defaultValue;
        }
    }


    /**
     * 函数功能描述:UTC时间转本地时间格式
     *
     * @param utcTime         UTC时间
     * @param utcTimePatten   UTC时间格式
     * @param localTimePatten 本地时间格式
     * @return 本地时间格式的时间
     * eg:utc2Local("2017-06-14 09:37:50.788+08:00", "yyyy-MM-dd HH:mm:ss.SSSXXX", "yyyy-MM-dd HH:mm:ss.SSS")
     */
    public static String utc2Local(String utcTime, String utcTimePatten, String localTimePatten) {
        SimpleDateFormat utcFormater = new SimpleDateFormat(utcTimePatten);
        utcFormater.setTimeZone(TimeZone.getTimeZone("UTC"));//时区定义并进行时间获取
        Date gpsUTCDate = null;
        try {
            gpsUTCDate = utcFormater.parse(utcTime);
        } catch (ParseException e) {
            e.printStackTrace();
            return utcTime;
        }
        SimpleDateFormat localFormater = new SimpleDateFormat(localTimePatten);
        localFormater.setTimeZone(TimeZone.getDefault());
        String localTime = localFormater.format(gpsUTCDate.getTime());
        return localTime;
    }

    /**
     * 函数功能描述:UTC时间转本地时间格式
     *
     * @param utcTime          UTC时间
     * @param localTimePattern 本地时间格式(要转换的本地时间格式)
     * @return 本地时间格式的时间
     */
    public static String utc2Local(String utcTime, String localTimePattern) {
        String utcTimePattern = "yyyy-MM-dd";
        String subTime = "";
        if (utcTime != null && utcTime.toCharArray().length >= 10) {
            subTime = utcTime.substring(10);//UTC时间格式以 yyyy-MM-dd 开头,将utc时间的前10位截取掉,之后是含有多时区时间格式信息的数据
        }


        //处理当后缀为:+8:00时,转换为:+08:00 或 -8:00转换为-08:00
        if (subTime.indexOf("+") != -1) {
            subTime = changeUtcSuffix(subTime, "+");
        }
        if (subTime.indexOf("-") != -1) {
            subTime = changeUtcSuffix(subTime, "-");
        }
        utcTime = utcTime.substring(0, 10) + subTime;

        //依据传入函数的utc时间,得到对应的utc时间格式
        //步骤一:处理 T
        if (utcTime.indexOf("T") != -1) {
            utcTimePattern = utcTimePattern + "'T'";
        }

        //步骤二:处理毫秒SSS
        if (utcTime.indexOf(".") != -1) {
            utcTimePattern = utcTimePattern + " HH:mm:ss.SSS";
        } else {
            utcTimePattern = utcTimePattern + " HH:mm:ss";
        }

        //步骤三:处理时区问题
        if (subTime.indexOf("+") != -1 || subTime.indexOf("-") != -1) {
            utcTimePattern = utcTimePattern + "XXX";
        } else if (subTime.indexOf("Z") != -1) {
            utcTimePattern = utcTimePattern + "'Z'";
        }

        if ("yyyy-MM-dd HH:mm:ss".equals(utcTimePattern) || "yyyy-MM-dd HH:mm:ss.SSS".equals(utcTimePattern)) {
            return utcTime;
        }

        SimpleDateFormat utcFormater = new SimpleDateFormat(utcTimePattern);
        utcFormater.setTimeZone(TimeZone.getTimeZone("UTC"));
        Date gpsUtcDate = null;
        try {
            gpsUtcDate = utcFormater.parse(utcTime);
        } catch (Exception e) {
            return utcTime;
        }
        SimpleDateFormat localFormater = new SimpleDateFormat(localTimePattern);
        localFormater.setTimeZone(TimeZone.getDefault());
        String localTime = localFormater.format(gpsUtcDate.getTime());
        return localTime;
    }

    /**
     * 函数功能描述:修改时间格式后缀
     * 函数使用场景:处理当后缀为:+8:00时,转换为:+08:00 或 -8:00转换为-08:00
     *
     * @param subTime
     * @param sign
     * @return
     */
    private static String changeUtcSuffix(String subTime, String sign) {
        String timeSuffix = null;
        String[] splitTimeArrayOne = subTime.split("\\" + sign);
        String[] splitTimeArrayTwo = splitTimeArrayOne[1].split(":");
        if (splitTimeArrayTwo[0].length() < 2) {
            timeSuffix = "+" + "0" + splitTimeArrayTwo[0] + ":" + splitTimeArrayTwo[1];
            subTime = splitTimeArrayOne[0] + timeSuffix;
            return subTime;
        }
        return subTime;
    }

    /**
     * 函数功能描述:获取本地时区的表示(比如:第八区-->+08:00)
     *
     * @return
     */
    public static String getTimeZoneByNumExpress() {
        Calendar cal = Calendar.getInstance();
        TimeZone timeZone = cal.getTimeZone();
        int rawOffset = timeZone.getRawOffset();
        int timeZoneByNumExpress = rawOffset / 3600 / 1000;
        String timeZoneByNumExpressStr = "";
        if (timeZoneByNumExpress > 0 && timeZoneByNumExpress < 10) {
            timeZoneByNumExpressStr = "+" + "0" + timeZoneByNumExpress + ":" + "00";
        } else if (timeZoneByNumExpress >= 10) {
            timeZoneByNumExpressStr = "+" + timeZoneByNumExpress + ":" + "00";
        } else if (timeZoneByNumExpress > -10 && timeZoneByNumExpress < 0) {
            timeZoneByNumExpress = Math.abs(timeZoneByNumExpress);
            timeZoneByNumExpressStr = "-" + "0" + timeZoneByNumExpress + ":" + "00";
        } else if (timeZoneByNumExpress <= -10) {
            timeZoneByNumExpress = Math.abs(timeZoneByNumExpress);
            timeZoneByNumExpressStr = "-" + timeZoneByNumExpress + ":" + "00";
        } else {
            timeZoneByNumExpressStr = "Z";
        }
        return timeZoneByNumExpressStr;
    }

}
