package com.kangxin.common.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.kangxin.common.Pretty;
import com.kangxin.common.R;
import com.kangxin.common.base.DynamicImageActivity;

import java.util.ArrayList;
import java.util.List;

public class DynamicImageView extends FrameLayout {

  private ImageView topLeft;
  private ImageView topRight;
  private ImageView bottomLeft;
  private ImageView bottomRight;
  private TextView countView;

  private ArrayList<String> images = new ArrayList<>();

  public DynamicImageView(@NonNull Context context) {
    super(context);
    init();
  }

  public DynamicImageView(@NonNull Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
    init();
  }

  public DynamicImageView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
    init();
  }

  private void init() {
    addView(inflate(getContext(), R.layout.inc_commbyh_layout_dynamic_image, null));
    topLeft = findViewById(R.id.dynamicImageTopLeft);
    topRight = findViewById(R.id.dynamicImageTopRight);
    bottomLeft = findViewById(R.id.dynamicImageBottomLeft);
    bottomRight = findViewById(R.id.dynamicImageBottomRight);
    countView = findViewById(R.id.dynamicImageCount);
    setOnClickListener(v -> DynamicImageActivity.start(images));
  }

  public void updateImage(List<String> images) {
    this.images.clear();
    this.images.addAll(images);
    update();
  }

  private void update() {
    int size = images.size();
    if (size == 1) {
      topRight.setVisibility(View.GONE);
      bottomLeft.setVisibility(View.GONE);
      bottomRight.setVisibility(View.GONE);
      updateImage(images.get(0), topLeft);
    } else if (size == 2) {
      bottomLeft.setVisibility(View.GONE);
      bottomRight.setVisibility(View.GONE);
      updateImage(images.get(0), topLeft);
      updateImage(images.get(1), topRight);
    } else if (size == 3) {
      bottomRight.setVisibility(View.GONE);
      updateImage(images.get(0), topLeft);
      updateImage(images.get(1), topRight);
      updateImage(images.get(2), bottomLeft);
    } else {
      updateImage(images.get(0), topLeft);
      updateImage(images.get(1), topRight);
      updateImage(images.get(2), bottomLeft);
      updateImage(images.get(3), bottomRight);
    }
    countView.setText(String.format("共 %s 张", size));
  }

  private void updateImage(String url, ImageView imageView) {
    Pretty.create()
      .loadImage(url)
      .centerCrop()
      .into(imageView);
  }
}
