package com.kangxin.common.widget;

import android.content.Context;

import com.blankj.utilcode.util.Utils;
import com.kangxin.common.byh.widget.DefEmptyPageProxy;
import com.kangxin.common.util.GlobeLoadingHelper;

import java.net.UnknownHostException;

import io.reactivex.observers.DefaultObserver;

public abstract class ProgressDialogObserver<T> extends DefaultObserver<T> {

    private static final String TAG = "ProgressDialogObserver";

    //上下文
    private Context mContext;

    public ProgressDialogObserver() {
        super();
        mContext = attachContext();
    }

    @Override
    protected void onStart() {
        GlobeLoadingHelper.show(mContext);
    }

    @Override
    public abstract void onNext(T t);

    @Override
    public void onError(Throwable t) {
        t.printStackTrace();

        if(t instanceof UnknownHostException){
            DefEmptyPageProxy.getInstance(Utils.getApp()).showNetErrPage();
        }else {
            //TODO 网络响应异常
        }
        GlobeLoadingHelper.dissmiss();
    }

    @Override
    public void onComplete() {
        GlobeLoadingHelper.dissmiss();
        DefEmptyPageProxy.getInstance(Utils.getApp()).loadDefEmptyPage();
    }

    protected abstract Context attachContext();

}
