package com.kangxin.common.widget;

import android.accounts.NetworkErrorException;
import android.text.TextUtils;

import com.blankj.utilcode.util.ToastUtils;
import com.blankj.utilcode.util.Utils;
import com.google.gson.JsonParseException;
import com.kangxin.common.R;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.byh.widget.DefEmptyPageProxy;
import com.kangxin.common.util.StringsUtils;

import java.net.UnknownHostException;

import io.reactivex.observers.DefaultObserver;
import retrofit2.HttpException;

import static com.kangxin.common.http.HttpResCode.REQ_OK;

public abstract class RxNoHintBaseObserver<T> extends DefaultObserver<T> {

    @Override
    public void onError(Throwable e) {
        e.printStackTrace();
        if(e instanceof UnknownHostException){
            DefEmptyPageProxy.getInstance(Utils.getApp()).showNetErrPage();
        }else {
            //TODO 网络响应异常
        }
    }

    @Override
    public void onNext(T t) {

        if (t instanceof ResponseBody) {
            ResponseBody responseBody = (ResponseBody) t;
            if (responseBody.getCode() != REQ_OK) {
                if (responseBody.getMsg().toString().contains("应用鉴权")) {
                    return;
                }
                onReqErr(responseBody.getCode(), responseBody.getMsg(),
                        responseBody.getErrCode());
                return;
            }
        }

        if (t instanceof UnknownHostException) {
            ToastUtils.showShort(StringsUtils.getString(R.string.common_qingjianchawangluolianjieshifoukeyong));
            DefEmptyPageProxy.getInstance(Utils.getApp()).showNetErrPage();
            return;
        } else if (t instanceof NetworkErrorException || t instanceof HttpException) {
            ToastUtils.showShort(StringsUtils.getString(R.string.common_wangluofangwencuowu));
            return;
        } else if (t instanceof JsonParseException) {
            return;
        } else if (t instanceof NullPointerException) {
            ToastUtils.showShort(t + "");
            return;
        } else if (t instanceof ArrayIndexOutOfBoundsException) {
            ToastUtils.showShort(t + "");
            return;
        }

        onReqNext(t);
    }

    public abstract void onReqNext(T t);

    public void onReqErr(Throwable e) {
        if(e instanceof UnknownHostException){
            DefEmptyPageProxy.getInstance(Utils.getApp()).showNetErrPage();
        }else {
            //TODO 网络响应异常
        }
    }

    public void onReqErr(int code, String msg, String errCode) {
        //后台接口异常
    }

    @Override
    public void onComplete() {
        DefEmptyPageProxy.getInstance(Utils.getApp()).loadDefEmptyPage();
    }
}
