package com.kangxin.common.widget;

import android.content.Context;
import android.graphics.Color;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.Nullable;

import com.kangxin.common.R;
import com.kangxin.common.util.StringsUtils;

/**
 * 左右切换，需要后期优化
 */
public class SwitchButtonView extends LinearLayout {


    private TextView leftTextView;
    private TextView rightTextView;

    private Context mContext;

    private OnClickListener listener;


    public SwitchButtonView(Context context) {
        this(context, null);
    }

    public SwitchButtonView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SwitchButtonView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        mContext = context;
        init();
        resolveAttribute();
        newInstanceTextView();
        addChildView();
        dispatchEvent();
    }

    private void dispatchEvent() {

        leftTextView.setOnClickListener(v -> {
            leftTextView.setBackground(getResources().getDrawable(R.drawable.by_background_circle_white_right));
            rightTextView.setBackground(null);
            leftTextView.setTextColor(mContext.getResources().getColor(R.color.colorPrimary));
            rightTextView.setTextColor(Color.WHITE);

            ViewGroup.LayoutParams layoutParams = new LayoutParams(0, ViewGroup.LayoutParams.MATCH_PARENT, 1.5f);
            leftTextView.setLayoutParams(layoutParams);

            ViewGroup.LayoutParams rightParams = new LayoutParams(0, ViewGroup.LayoutParams.MATCH_PARENT, 1f);
            rightTextView.setLayoutParams(rightParams);
            if (listener != null)
                listener.onLeftClick();

        });

        rightTextView.setOnClickListener(v -> {
            rightTextView.setBackground(getResources().getDrawable(R.drawable.by_background_circle_white_right));
            leftTextView.setBackground(null);
            rightTextView.setTextColor(mContext.getResources().getColor(R.color.colorPrimary));
            leftTextView.setTextColor(Color.WHITE);

            ViewGroup.LayoutParams layoutParams = new LayoutParams(0, ViewGroup.LayoutParams.MATCH_PARENT, 1f);
            leftTextView.setLayoutParams(layoutParams);

            ViewGroup.LayoutParams rightParams = new LayoutParams(0, ViewGroup.LayoutParams.MATCH_PARENT, 1.5f);
            rightTextView.setLayoutParams(rightParams);

            if (listener != null)
                listener.onRightClick();

        });

    }

    /**
     * 初始化，设置布局权重为1，竖着排列
     */
    private void init() {

//        setHorizontalGravity(LinearLayout.VERTICAL);

    }

    /**
     * 添加子view
     */
    private void addChildView() {


        addView(leftTextView, new LayoutParams(0, ViewGroup.LayoutParams.MATCH_PARENT, 1.5f));
        addView(rightTextView, new LayoutParams(0, ViewGroup.LayoutParams.MATCH_PARENT, 1f));

    }

    /**
     * 生成左右文本对象，设置权重为1
     */
    private void newInstanceTextView() {

//        setPadding(0,0,0,0);

        leftTextView = new TextView(mContext);

        leftTextView.setText(StringsUtils.getString(R.string.common_shenqing));
        leftTextView.setTextColor(mContext.getResources().getColor(R.color.colorPrimary));
        leftTextView.setTextSize(12);
        leftTextView.setGravity(Gravity.CENTER);
        leftTextView.setBackground(getResources().getDrawable(R.drawable.by_background_circle_white_right));


        //高度撑满，宽度权重为1


        rightTextView = new TextView(mContext);
        rightTextView.setText(StringsUtils.getString(R.string.common_jiezhen));
        rightTextView.setTextColor(Color.WHITE);
        rightTextView.setTextSize(12);
        rightTextView.setGravity(Gravity.CENTER);


    }

    /**
     * 解析属性
     */
    private void resolveAttribute() {

    }


    public void setListener(OnClickListener listener) {
        this.listener = listener;
    }

    public interface OnClickListener {
        void onLeftClick();

        void onRightClick();
    }

}
