package com.kangxin.common.widget.layout;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.Nullable;

import com.kangxin.common.R;

public class PlaceHolderLinearLayout extends LinearLayout {
    public PlaceHolderLinearLayout(Context context) {
        this(context, null);
    }

    public PlaceHolderLinearLayout(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }


    private View mPlaceView;
    private TextView mPlaceBtnView;

    public View getPlaceView(){
        return mPlaceView;
    }

    public TextView getPlaceBtnView(){
        return mPlaceBtnView;
    }


    private static final Integer PLACE_VIEW_TAG = 0x110;
    public PlaceHolderLinearLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);

        mPlaceView = LayoutInflater.from(context).inflate(R.layout.commbyh_list_empty_place2, this, false);
        mPlaceView.setTag(PLACE_VIEW_TAG);

        mPlaceView.setVisibility(View.GONE);
        addView(mPlaceView);

        ImageView placeImgView = findViewById(R.id.place_img);
        TextView placeDescView = findViewById(R.id.place_seat_desc);
        TextView placeDescEngView = findViewById(R.id.place_seat_desc2);
        mPlaceBtnView = findViewById(R.id.def_page_btn);

        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.PlaceHolderLinearLayout);
        int placeImg = typedArray.getResourceId(R.styleable.PlaceHolderLinearLayout_place_img, 0);
        String placeDesc = typedArray.getString(R.styleable.PlaceHolderLinearLayout_place_desc);
        String placeDescEng = typedArray.getString(R.styleable.PlaceHolderLinearLayout_place_desc_eng);
        boolean isShowBtn = typedArray.getBoolean(R.styleable.PlaceHolderLinearLayout_place_showbtn, false);

        if(placeImg != 0){
            placeImgView.setImageResource(placeImg);
        }

        if(placeDesc != null){
            placeDescView.setText(placeDesc);
        }

        if(placeDescEng != null){
            placeDescEngView.setText(placeDescEng);
        }

        if(isShowBtn){
            mPlaceBtnView.setVisibility(View.VISIBLE);
        }else {
            mPlaceBtnView.setVisibility(View.GONE);
        }
        typedArray.recycle();
    }


    public void showPlaceView(){
        int childCount = getChildCount();
        for (int i = 0; i < childCount; i++) {
            View childView = getChildAt(i);
            Object viewTag = childView.getTag();
            if(viewTag != null && viewTag == PLACE_VIEW_TAG){
                childView.setVisibility(View.VISIBLE);
            }else {
                childView.setVisibility(View.GONE);
            }
        }
    }


    public void hidePlaceView(){
        int childCount = getChildCount();
        for (int i = 0; i < childCount; i++) {
            View childView = getChildAt(i);
            Object viewTag = childView.getTag();
            if(viewTag != null && viewTag == PLACE_VIEW_TAG){
                childView.setVisibility(View.GONE);
            }else {
                childView.setVisibility(View.VISIBLE);
            }
        }
    }

}
