package com.kangxin.doctor.worktable.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;

public class DelayUtils {

    private static Map<Object, Build> timerMap = new HashMap<>();
    //订阅者管理
    private static CompositeDisposable compositeDisposable = new CompositeDisposable();

    private DelayUtils() {

    }

    //重置一个计时任务的回调事件
    public static void resetListener(Object key, Delay delay) {

        if (timerMap.get(key) == null)
            return;

        Objects.requireNonNull(timerMap.get(key)).listenerList.clear();
        Objects.requireNonNull(timerMap.get(key)).listenerList.add(delay);

    }

    //新增一个任务的回调事件
    public static void addListener(Object key, Delay delay) {

        if (timerMap.get(key) == null)
            return;

        Objects.requireNonNull(timerMap.get(key)).listenerList.add(delay);
    }

    //刷新一个正在运行任务的时间
    public static void updateTime(Object key, long allSecond, long extSecond) {

        Build build = timerMap.get(key);
        if (build == null)
            return;
        if (allSecond != -1)
            build.allSecond = allSecond;

        if (extSecond != -1)
            build.exeSecond = extSecond;

    }

    //获取一个任务的已执行时间
    public static long getTaskExeTime(Object key) {

        Build build = timerMap.get(key);
        if (build == null)
            return -1;

        return build.exeSecond;
    }

    //获取一个任务的总时间
    public static long getTaskAllTime(Object key) {

        Build build = timerMap.get(key);
        if (build == null)
            return -1;

        return build.allSecond;
    }

    public static boolean hasRunningTask(Object key) {
        return timerMap.get(key) != null;
    }

    public static Build creatFactory(Object key) {

        if (timerMap.get(key) != null)
            remove(key);

        return new Build(key);
    }

    //移除一个计时任务
    public static void remove(Object key) {

        if (timerMap.get(key) == null)
            return;

        compositeDisposable.remove(Objects.requireNonNull(timerMap.get(key)).disposable);
        timerMap.remove(key);
    }

    //移除计时任务的一个回调
    public static void removeListener(Object key, Delay delay) {

        if (timerMap.get(key) == null)
            return;

        Objects.requireNonNull(timerMap.get(key)).listenerList.remove(delay);
    }

    //清空所有
    public static void clear() {
        timerMap.clear();
        compositeDisposable.clear();
    }

    public interface Delay {
        void delay(long allTimeSecond, long exeTimeSecond, long signTimeSecond);
    }

    public static class Build {

        Object key;

        long exeSecond = 0;

        long allSecond = 0;

        long signSecond = 0;

        Disposable disposable;

        List<Delay> listenerList = new ArrayList<>();

        private Build(Object key) {
            this.key = key;
        }

        public Build bindTaskTime(long second) {
            this.allSecond = second;
            return this;
        }

        public Build bindSignTime(long sign) {
            signSecond = sign;
            return this;
        }


        public Build bindListener(Delay delay) {
            listenerList.add(delay);
            return this;
        }

        public void start() {

            timerMap.put(key, this);

            Observable.interval(0, 1, TimeUnit.SECONDS)
                    .observeOn(AndroidSchedulers.mainThread())
                    .subscribe(new Observer<Long>() {
                        @Override
                        public void onSubscribe(Disposable d) {
                            compositeDisposable.add(d);
                            disposable = d;
                        }

                        @Override
                        public void onNext(Long aLong) {

                            if (exeSecond <= allSecond) {
                                if (listenerList.size() == 0)
                                    return;

                                exeSecond++;

                                for (Delay item : listenerList) {
                                    item.delay(allSecond, exeSecond, signSecond);
                                }

                            } else disposable.dispose();

                        }

                        @Override
                        public void onError(Throwable e) {
                            start();
                        }

                        @Override
                        public void onComplete() {

                        }
                    });
        }
    }
}

