package com.kangxin.doctor.worktable.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.text.Editable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.EditText;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.kangxin.common.R;


public class ConsuApplySelItemView extends RelativeLayout {

    private static final String TAG = "ConsuApplySelItemView";
    private TextView mLabelConsuView;
    private TextView mNothingTextView;
    private TextView mHasExitTextView;

    private EditText mEditConsuCaseView;
    private OnHasCaseDescListener onHasCaseDescListener;

    public ConsuApplySelItemView(Context context) {
        this(context, null);
    }

    public ConsuApplySelItemView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }


    public ConsuApplySelItemView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        LayoutInflater.from(context).inflate(R.layout.worktab_consuapply_selitem, this);

        mLabelConsuView = findViewById(R.id.caselabel_name);
        mNothingTextView = findViewById(R.id.nothing_txt);
        mHasExitTextView = findViewById(R.id.have_exist_txt);
        mEditConsuCaseView = findViewById(R.id.edt_consu_info);

        TypedArray typedArray = getContext().obtainStyledAttributes(attrs, R.styleable.ConsuApplySelItemView);
        String labelConsuName = typedArray.getString(R.styleable.ConsuApplySelItemView_label_name_consu);
        String hintConsuDesc = typedArray.getString(R.styleable.ConsuApplySelItemView_hint_desc_consucase);
        boolean isShowExpand = typedArray.getBoolean(R.styleable.ConsuApplySelItemView_is_show_expand_edtconsu, false);
        typedArray.recycle();

        if (labelConsuName != null) {
            mLabelConsuView.setText(labelConsuName);
        }

        if (hintConsuDesc != null) {
            mEditConsuCaseView.setHint(hintConsuDesc);
        }

        expandEdtView(isShowExpand);


        mNothingTextView.setOnClickListener(v -> {
            //点击无
            expandEdtView(false);
            if (onHasCaseDescListener != null) {
                onHasCaseDescListener.onHasCaseDesc(false, mEditConsuCaseView.getText());
            }
        });


        mHasExitTextView.setOnClickListener(v -> {
            //点击有
            expandEdtView(true);
            if (onHasCaseDescListener != null) {
                onHasCaseDescListener.onHasCaseDesc(true, mEditConsuCaseView.getText());
            }
        });
    }

    public void setOnHasCaseDescListener(OnHasCaseDescListener onHasCaseDescListener) {
        this.onHasCaseDescListener = onHasCaseDescListener;
    }

    public Editable getContentText() {
        return mEditConsuCaseView.getText();
    }

    public void setContentText(String content) {
        mEditConsuCaseView.setText(content);
    }

    public void expandEdtView(boolean isExpand) {
        if (isExpand) {
            mNothingTextView.setTextColor(Color.parseColor("#666666"));
            mHasExitTextView.setTextColor(Color.parseColor("#3576E0"));
            mNothingTextView.setBackgroundResource(R.drawable.by_background_white_low);
            mHasExitTextView.setBackgroundResource(R.drawable.by_background_blue_low);
            mEditConsuCaseView.setVisibility(View.VISIBLE);
        } else {
            mNothingTextView.setTextColor(Color.parseColor("#3576E0"));
            mHasExitTextView.setTextColor(Color.parseColor("#666666"));
            mNothingTextView.setBackgroundResource(R.drawable.by_background_blue_low);
            mHasExitTextView.setBackgroundResource(R.drawable.by_background_white_low);
            mEditConsuCaseView.setVisibility(View.GONE);
            mEditConsuCaseView.setText("");

        }
    }

    public interface OnHasCaseDescListener {
        void onHasCaseDesc(boolean hasDesc, Editable editable);
    }
}
