package com.kangxin.doctor.worktable.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.annotation.ColorInt;
import androidx.appcompat.widget.SwitchCompat;

import com.kangxin.common.R;


/**
 * 执业管理的item
 */
public class PractisManagerItem extends RelativeLayout {

    private Context mContext;
    private View mValueLayoutView;
    private TextView mValueNameView;
    private SwitchCompat mSwitchView;
    private TextView mLabelNameView;
    private ImageView mRightArrowView;
    private ItemType mItemType;

    public PractisManagerItem(Context context) {
        this(context, null);
    }

    public PractisManagerItem(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PractisManagerItem(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        mContext = context;
        LayoutInflater.from(context).inflate(R.layout.worktab_practis_manager_item, this);

        mValueLayoutView = findViewById(R.id.value_layout);
        mValueNameView = findViewById(R.id.value_name);
        mSwitchView = findViewById(R.id.switch_btn);
        mLabelNameView = findViewById(R.id.label_name_txt);
        mRightArrowView = findViewById(R.id.right_arrow_img);
    }

    public SwitchCompat getSwitchCompatView() {
        return mSwitchView;
    }

    public void setLabelName(String labelName) {
        mLabelNameView.setText(labelName);
    }

    public void showItemType(ItemType itemType) {
        mItemType = itemType;
        switch (itemType) {
            case NORMAL:
                mSwitchView.setVisibility(View.GONE);
                mValueLayoutView.setVisibility(View.VISIBLE);
                mValueNameView.setVisibility(View.GONE);
                mRightArrowView.setVisibility(View.VISIBLE);
                break;
            case LABEL:
                mSwitchView.setVisibility(View.GONE);
                mValueLayoutView.setVisibility(View.VISIBLE);
                mValueNameView.setVisibility(View.VISIBLE);
                mRightArrowView.setVisibility(View.VISIBLE);
                break;
            case NOOPEN:
                mSwitchView.setVisibility(View.GONE);
                mValueLayoutView.setVisibility(View.VISIBLE);
                mRightArrowView.setVisibility(View.GONE);
                mValueNameView.setVisibility(View.VISIBLE);
                break;
            case SWITCH:
                mValueLayoutView.setVisibility(View.GONE);
                mSwitchView.setVisibility(View.VISIBLE);
                break;
        }
    }

    public void setValueNameColor(@ColorInt int color) {
        mValueNameView.setTextColor(color);
    }

    public void setValueName(String valueName) {
        mValueNameView.setText(valueName);
    }

    public enum ItemType {
        NORMAL,
        LABEL,
        NOOPEN,
        SWITCH
    }
}
