package com.kangxin.utils;

import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.provider.MediaStore;

import androidx.core.content.FileProvider;

import com.blankj.utilcode.util.Utils;

import java.io.File;
import java.io.FileNotFoundException;

/**
 * @Package: com.kangxin.common.byh.util
 * @ClassName: MediaFileNotify
 * @Description:
 * @Author: SWY
 * @CreateDate: 2020/5/12 4:08 PM
 */
public class MediaUtils {

  private static Uri uri2File(File file) {
    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
      String authority = Utils.getApp().getPackageName() + ".FileProvider";
      return FileProvider.getUriForFile(Utils.getApp(), authority, file);
    } else {
      return Uri.fromFile(file);
    }
  }

  public static void notifyPicture(File file) {

    Utils.getApp().sendBroadcast(new Intent(Intent.ACTION_MEDIA_SCANNER_SCAN_FILE, uri2File(file)));
    try {
      MediaStore.Images.Media.insertImage(Utils.getApp().getContentResolver(), file.getAbsolutePath(), file.getName(), "CA人脸认证");
    } catch (FileNotFoundException e) {
      e.printStackTrace();
    }
  }


}
