/*
 * Decompiled with CFR 0.152.
 */
package com.byh.lib.byhim.utils;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.text.SpannableString;
import android.text.TextUtils;
import android.widget.TextView;
import com.byh.lib.byhim.utils.DisplayUtil;
import com.byh.lib.byhim.utils.EmojiMapUtil;
import com.byh.lib.byhim.utils.UrlImageSpan;
import com.kangxin.common.R;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EmojiUtil {
    private static EmojiUtil INSTANCE = new EmojiUtil();

    private EmojiUtil() {
    }

    public static EmojiUtil getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new EmojiUtil();
        }
        return INSTANCE;
    }

    public void showEmoText(Context context, String text, TextView textView) {
        char[] chars = text.toCharArray();
        ArrayList<Integer> leftIndexList = new ArrayList<Integer>();
        ArrayList<Integer> rightIndexList = new ArrayList<Integer>();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '[') {
                leftIndexList.add(i);
            }
            if (chars[i] != ']') continue;
            rightIndexList.add(i);
        }
        if (leftIndexList.size() == rightIndexList.size()) {
            SpannableString spannableString = new SpannableString((CharSequence)text);
            for (int index = 0; index < leftIndexList.size(); ++index) {
                int endIndex;
                int startIndex = (Integer)leftIndexList.get(index);
                String emojiStr = text.substring(startIndex, (endIndex = ((Integer)rightIndexList.get(index)).intValue()) + 1);
                String emoUrl = EmojiMapUtil.INSTANCE.getEmojiUrl(emojiStr);
                if (emoUrl != null) {
                    Bitmap bitmap = BitmapFactory.decodeResource((Resources)context.getResources(), (int)R.drawable.ic_placeshow_img);
                    bitmap = UrlImageSpan.zoom(bitmap, DisplayUtil.dp2px(context, 20.0f));
                    UrlImageSpan imageSpan = new UrlImageSpan(context, emoUrl, bitmap, textView);
                    spannableString.setSpan((Object)imageSpan, startIndex, endIndex + 1, 33);
                    textView.setText((CharSequence)spannableString);
                    continue;
                }
                textView.setText((CharSequence)text);
            }
        } else {
            textView.setText((CharSequence)text);
        }
    }

    public boolean checkEmojiInText(String text) {
        if (TextUtils.isEmpty((CharSequence)text)) {
            return false;
        }
        Pattern p = Pattern.compile("(\\[[^\\]]*\\])");
        Matcher m = p.matcher(text);
        return m.find();
    }
}

