/*
 * Decompiled with CFR 0.152.
 */
package com.byh.lib.byhim.utils;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;

public class NetworkUtil {
    public static final int NO_CONNECTION = 0;
    public static final int WIFI = 1;
    public static final int MOBILE = 2;

    public static boolean isWifi(Context context) {
        return NetworkUtil.isNetworkConnected(context) && NetworkUtil.getConnectedType(context) == 1;
    }

    public static boolean isNetworkConnected(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo info = connectivityManager.getActiveNetworkInfo();
        return info != null && info.isConnected();
    }

    public static boolean checkNetworkAvailable(Context context) {
        boolean flag = false;
        ConnectivityManager netManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (netManager.getActiveNetworkInfo() != null) {
            flag = netManager.getActiveNetworkInfo().isAvailable();
        }
        return flag;
    }

    public static void openSetting(Activity activity) {
        Intent intent = new Intent("/");
        ComponentName cm = new ComponentName("com.android.settings", "com.android.settings.WirelessSettings");
        intent.setComponent(cm);
        intent.setAction("android.intent.action.VIEW");
        activity.startActivityForResult(intent, 0);
    }

    public static int getNetworkType(Context context) {
        ConnectivityManager connMgr = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connMgr.getActiveNetworkInfo();
        int networkType = 0;
        if (networkInfo != null) {
            int type = networkInfo.getType();
            networkType = type == 1 ? 1 : 2;
        }
        return networkType;
    }

    public static int getConnectedType(Context context) {
        ConnectivityManager mConnectivityManager;
        NetworkInfo mNetworkInfo;
        if (context != null && (mNetworkInfo = (mConnectivityManager = (ConnectivityManager)context.getSystemService("connectivity")).getActiveNetworkInfo()) != null && mNetworkInfo.isAvailable()) {
            return mNetworkInfo.getType();
        }
        return -1;
    }

    public boolean isWifiConnected(Context context) {
        ConnectivityManager mConnectivityManager;
        NetworkInfo mWiFiNetworkInfo;
        if (context != null && (mWiFiNetworkInfo = (mConnectivityManager = (ConnectivityManager)context.getSystemService("connectivity")).getNetworkInfo(1)) != null) {
            return mWiFiNetworkInfo.isAvailable();
        }
        return false;
    }

    public boolean isMobileConnected(Context context) {
        ConnectivityManager mConnectivityManager;
        NetworkInfo mMobileNetworkInfo;
        if (context != null && (mMobileNetworkInfo = (mConnectivityManager = (ConnectivityManager)context.getSystemService("connectivity")).getNetworkInfo(0)) != null) {
            return mMobileNetworkInfo.isAvailable();
        }
        return false;
    }
}

