/*
 * Decompiled with CFR 0.152.
 */
package com.byh.lib.byhim.utils;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.style.DynamicDrawableSpan;
import android.text.style.ImageSpan;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.target.SimpleTarget;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.Transition;
import com.byh.lib.byhim.utils.DisplayUtil;
import java.lang.reflect.Field;

public class UrlImageSpan
extends ImageSpan {
    public static final int EMOJI_SIZE = 20;
    private String url;
    private Context mContext;
    private TextView mTextView;

    public UrlImageSpan(Context context, String url, Bitmap bitmap, TextView textView) {
        super(context, bitmap);
        this.mContext = context;
        this.mTextView = textView;
        this.url = url;
    }

    public static Bitmap zoom(@NonNull Bitmap bmp, int newW) {
        int width = bmp.getWidth();
        int height = bmp.getHeight();
        float scale = (float)newW / (float)width;
        Matrix matrix = new Matrix();
        matrix.postScale(scale, scale);
        Bitmap newbm = Bitmap.createBitmap((Bitmap)bmp, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
        return newbm;
    }

    public Drawable getDrawable() {
        Glide.with((Context)this.mContext).asBitmap().load(this.url).into((Target)new SimpleTarget<Bitmap>(){

            public void onResourceReady(@NonNull Bitmap resource, @Nullable Transition<? super Bitmap> transition) {
                UrlImageSpan.this.setNetBitmap(resource);
            }
        });
        return super.getDrawable();
    }

    private void setNetBitmap(Bitmap resource) {
        Resources res = this.mContext.getResources();
        int targetWidth = DisplayUtil.dp2px(this.mContext, 20.0f);
        Bitmap zoom = UrlImageSpan.zoom(resource, targetWidth);
        BitmapDrawable b = new BitmapDrawable(res, zoom);
        b.setBounds(0, 0, b.getIntrinsicWidth(), b.getIntrinsicHeight());
        try {
            Field mDrawable = ImageSpan.class.getDeclaredField("mDrawable");
            mDrawable.setAccessible(true);
            mDrawable.set((Object)this, b);
            Field mDrawableRef = DynamicDrawableSpan.class.getDeclaredField("mDrawableRef");
            mDrawableRef.setAccessible(true);
            mDrawableRef.set((Object)this, null);
            if (this.mTextView != null) {
                this.mTextView.setText(this.mTextView.getText());
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
    }
}

