/*
 * Decompiled with CFR 0.152.
 */
package com.floatwindow;

import android.content.Context;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import com.floatwindow.FloatActivity;
import com.floatwindow.FloatView;
import com.floatwindow.LogUtil;
import com.floatwindow.Miui;
import com.floatwindow.PermissionListener;

class FloatPhone
extends FloatView {
    private final Context mContext;
    private final WindowManager mWindowManager;
    private final WindowManager.LayoutParams mLayoutParams;
    private View mView;
    private int mX;
    private int mY;
    private boolean isRemove = false;
    private PermissionListener mPermissionListener;

    FloatPhone(Context applicationContext, PermissionListener permissionListener) {
        this.mContext = applicationContext;
        this.mPermissionListener = permissionListener;
        this.mWindowManager = (WindowManager)applicationContext.getSystemService("window");
        this.mLayoutParams = new WindowManager.LayoutParams();
        this.mLayoutParams.format = 1;
        this.mLayoutParams.flags = 552;
        this.mLayoutParams.windowAnimations = 0;
    }

    @Override
    public void setSize(int width, int height) {
        this.mLayoutParams.width = width;
        this.mLayoutParams.height = height;
    }

    @Override
    public void setView(View view) {
        this.mView = view;
    }

    @Override
    public void setGravity(int gravity, int xOffset, int yOffset) {
        this.mLayoutParams.gravity = gravity;
        this.mLayoutParams.x = this.mX = xOffset;
        this.mLayoutParams.y = this.mY = yOffset;
    }

    @Override
    public void init() {
        if (Build.VERSION.SDK_INT >= 25) {
            this.req();
        } else if (Miui.rom()) {
            if (Build.VERSION.SDK_INT >= 23) {
                this.req();
            } else {
                this.mLayoutParams.type = 2002;
                Miui.req(this.mContext, new PermissionListener(){

                    @Override
                    public void onSuccess() {
                        FloatPhone.this.mWindowManager.addView(FloatPhone.this.mView, (ViewGroup.LayoutParams)FloatPhone.this.mLayoutParams);
                        if (FloatPhone.this.mPermissionListener != null) {
                            FloatPhone.this.mPermissionListener.onSuccess();
                        }
                    }

                    @Override
                    public void onFail() {
                        if (FloatPhone.this.mPermissionListener != null) {
                            FloatPhone.this.mPermissionListener.onFail();
                        }
                    }
                });
            }
        } else {
            try {
                this.mLayoutParams.type = 2005;
                this.mWindowManager.addView(this.mView, (ViewGroup.LayoutParams)this.mLayoutParams);
            }
            catch (Exception e) {
                this.removeView();
                LogUtil.e("TYPE_TOAST \u5931\u8d25");
                this.req();
            }
        }
    }

    private void removeView() {
        try {
            this.mWindowManager.removeView(this.mView);
        }
        catch (Exception e) {
            LogUtil.e("TYPE_TOAST \u5931\u8d25");
        }
    }

    private void req() {
        this.mLayoutParams.type = Build.VERSION.SDK_INT >= 26 ? 2038 : 2002;
        FloatActivity.request(this.mContext, new PermissionListener(){

            @Override
            public void onSuccess() {
                FloatPhone.this.mWindowManager.addView(FloatPhone.this.mView, (ViewGroup.LayoutParams)FloatPhone.this.mLayoutParams);
                if (FloatPhone.this.mPermissionListener != null) {
                    FloatPhone.this.mPermissionListener.onSuccess();
                }
            }

            @Override
            public void onFail() {
                if (FloatPhone.this.mPermissionListener != null) {
                    FloatPhone.this.mPermissionListener.onFail();
                }
            }
        });
    }

    @Override
    public void dismiss() {
        this.isRemove = true;
        this.removeView();
    }

    @Override
    public void updateXY(int x, int y) {
        if (this.isRemove) {
            return;
        }
        this.mLayoutParams.x = this.mX = x;
        this.mLayoutParams.y = this.mY = y;
        this.mWindowManager.updateViewLayout(this.mView, (ViewGroup.LayoutParams)this.mLayoutParams);
    }

    @Override
    void updateX(int x) {
        if (this.isRemove) {
            return;
        }
        this.mLayoutParams.x = this.mX = x;
        this.mWindowManager.updateViewLayout(this.mView, (ViewGroup.LayoutParams)this.mLayoutParams);
    }

    @Override
    void updateY(int y) {
        if (this.isRemove) {
            return;
        }
        this.mLayoutParams.y = this.mY = y;
        this.mWindowManager.updateViewLayout(this.mView, (ViewGroup.LayoutParams)this.mLayoutParams);
    }

    @Override
    int getX() {
        return this.mX;
    }

    @Override
    int getY() {
        return this.mY;
    }
}

