/*
 * Decompiled with CFR 0.152.
 */
package com.floatwindow;

import android.content.Context;
import android.view.View;
import android.view.WindowManager;
import android.widget.Toast;
import com.floatwindow.FloatView;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

class FloatToast
extends FloatView {
    private Toast toast;
    private Object mTN;
    private Method show;
    private Method hide;
    private int mWidth;
    private int mHeight;

    FloatToast(Context applicationContext) {
        this.toast = new Toast(applicationContext);
    }

    @Override
    public void setSize(int width, int height) {
        this.mWidth = width;
        this.mHeight = height;
    }

    @Override
    public void setView(View view) {
        this.toast.setView(view);
        this.initTN();
    }

    @Override
    public void setGravity(int gravity, int xOffset, int yOffset) {
        this.toast.setGravity(gravity, xOffset, yOffset);
    }

    @Override
    public void init() {
        try {
            this.show.invoke(this.mTN, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void dismiss() {
        try {
            this.hide.invoke(this.mTN, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initTN() {
        try {
            Field tnField = this.toast.getClass().getDeclaredField("mTN");
            tnField.setAccessible(true);
            this.mTN = tnField.get(this.toast);
            this.show = this.mTN.getClass().getMethod("show", new Class[0]);
            this.hide = this.mTN.getClass().getMethod("hide", new Class[0]);
            Field tnParamsField = this.mTN.getClass().getDeclaredField("mParams");
            tnParamsField.setAccessible(true);
            WindowManager.LayoutParams params = (WindowManager.LayoutParams)tnParamsField.get(this.mTN);
            params.flags = 40;
            params.width = this.mWidth;
            params.height = this.mHeight;
            params.windowAnimations = 0;
            Field tnNextViewField = this.mTN.getClass().getDeclaredField("mNextView");
            tnNextViewField.setAccessible(true);
            tnNextViewField.set(this.mTN, this.toast.getView());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

