/*
 * Decompiled with CFR 0.152.
 */
package com.floatwindow;

import android.app.AppOpsManager;
import android.content.Context;
import android.os.Binder;
import android.os.Build;
import android.provider.Settings;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import androidx.annotation.RequiresApi;
import com.floatwindow.LogUtil;
import java.lang.reflect.Method;

class PermissionUtil {
    PermissionUtil() {
    }

    static boolean hasPermission(Context context) {
        if (Build.VERSION.SDK_INT >= 23) {
            return Settings.canDrawOverlays((Context)context);
        }
        return PermissionUtil.hasPermissionBelowMarshmallow(context);
    }

    static boolean hasPermissionOnActivityResult(Context context) {
        if (Build.VERSION.SDK_INT == 26) {
            return PermissionUtil.hasPermissionForO(context);
        }
        if (Build.VERSION.SDK_INT >= 23) {
            return Settings.canDrawOverlays((Context)context);
        }
        return PermissionUtil.hasPermissionBelowMarshmallow(context);
    }

    static boolean hasPermissionBelowMarshmallow(Context context) {
        try {
            AppOpsManager manager = (AppOpsManager)context.getSystemService("appops");
            Method dispatchMethod = AppOpsManager.class.getMethod("checkOp", Integer.TYPE, Integer.TYPE, String.class);
            return 0 == (Integer)dispatchMethod.invoke((Object)manager, 24, Binder.getCallingUid(), context.getApplicationContext().getPackageName());
        }
        catch (Exception e) {
            return false;
        }
    }

    @RequiresApi(api=23)
    private static boolean hasPermissionForO(Context context) {
        try {
            WindowManager mgr = (WindowManager)context.getSystemService("window");
            if (mgr == null) {
                return false;
            }
            View viewToAdd = new View(context);
            WindowManager.LayoutParams params = new WindowManager.LayoutParams(0, 0, Build.VERSION.SDK_INT >= 26 ? 2038 : 2003, 24, -2);
            viewToAdd.setLayoutParams((ViewGroup.LayoutParams)params);
            mgr.addView(viewToAdd, (ViewGroup.LayoutParams)params);
            mgr.removeView(viewToAdd);
            return true;
        }
        catch (Exception e) {
            LogUtil.e("hasPermissionForO e:" + e.toString());
            return false;
        }
    }
}

