/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.base;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewpager2.widget.ViewPager2;
import com.blankj.utilcode.util.Utils;
import com.chad.library.adapter.base.BaseViewHolder;
import com.kangxin.common.Pretty;
import com.kangxin.common.R;
import com.kangxin.common.base.rmvp.BaseActivity;
import java.util.ArrayList;

public class DynamicImageActivity
extends BaseActivity {
    private static final String IMAGE = "images";

    public static void start(ArrayList<String> images) {
        Bundle bundle = new Bundle();
        bundle.putStringArrayList(IMAGE, images);
        Intent intent = new Intent((Context)Utils.getApp(), DynamicImageActivity.class);
        intent.putExtras(bundle);
        intent.setFlags(0x10000000);
        Utils.getApp().startActivity(intent);
    }

    @Override
    @SuppressLint(value={"StringFormatMatches"})
    public void goStart() {
        ViewPager2 viewPager = (ViewPager2)this.findViewById(R.id.viewPager);
        if (this.getIntent().getExtras() == null) {
            this.finish();
            return;
        }
        final ArrayList arrayList = this.getIntent().getExtras().getStringArrayList(IMAGE);
        if (arrayList == null) {
            this.finish();
            return;
        }
        this.vToolTitleTextView.setText((CharSequence)String.format(this.getString(R.string.inc_dynamic_image_title), 1, arrayList.size()));
        viewPager.registerOnPageChangeCallback(new ViewPager2.OnPageChangeCallback(){

            public void onPageSelected(int position) {
                DynamicImageActivity.this.vToolTitleTextView.setText((CharSequence)String.format(DynamicImageActivity.this.getString(R.string.inc_dynamic_image_title), position + 1, arrayList.size()));
            }
        });
        viewPager.setAdapter((RecyclerView.Adapter)new RecyclerView.Adapter<BaseViewHolder>(){

            @NonNull
            public BaseViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
                return new BaseViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.inc_dynamic_image_item, parent, false));
            }

            public void onBindViewHolder(@NonNull BaseViewHolder holder, int position) {
                Pretty.create().loadImage((String)arrayList.get(position)).into((ImageView)holder.getView(R.id.image));
            }

            public int getItemCount() {
                return arrayList.size();
            }
        });
    }

    @Override
    public int getContentLayoutId() {
        return R.layout.inc_activity_dynamic_image;
    }
}

